package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265ScanType {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265ScanType
}
object H265ScanType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265ScanType
  ): zio.aws.medialive.model.H265ScanType = value match {
    case software.amazon.awssdk.services.medialive.model.H265ScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265ScanType.INTERLACED =>
      val r = INTERLACED
      r
    case software.amazon.awssdk.services.medialive.model.H265ScanType.PROGRESSIVE =>
      val r = PROGRESSIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H265ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ScanType =
      software.amazon.awssdk.services.medialive.model.H265ScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERLACED extends zio.aws.medialive.model.H265ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ScanType =
      software.amazon.awssdk.services.medialive.model.H265ScanType.INTERLACED
  }
  case object PROGRESSIVE extends zio.aws.medialive.model.H265ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ScanType =
      software.amazon.awssdk.services.medialive.model.H265ScanType.PROGRESSIVE
  }
}
