package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265SceneChangeDetect {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect
}
object H265SceneChangeDetect {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect
  ): zio.aws.medialive.model.H265SceneChangeDetect = value match {
    case software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.H265SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.H265SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect.ENABLED
  }
}
