package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin100000Max80000000,
  __integerMin1Max10,
  __integerMin0,
  __double,
  __integerMin100000Max40000000,
  __integerMin1Max3003,
  __integerMin1,
  __integerMin0Max30,
  __integerMin1Max16
}
import scala.jdk.CollectionConverters._
final case class H265Settings(
    adaptiveQuantization: Option[
      zio.aws.medialive.model.H265AdaptiveQuantization
    ] = None,
    afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] = None,
    alternativeTransferFunction: Option[
      zio.aws.medialive.model.H265AlternativeTransferFunction
    ] = None,
    bitrate: Option[__integerMin100000Max40000000] = None,
    bufSize: Option[__integerMin100000Max80000000] = None,
    colorMetadata: Option[zio.aws.medialive.model.H265ColorMetadata] = None,
    colorSpaceSettings: Option[zio.aws.medialive.model.H265ColorSpaceSettings] =
      None,
    filterSettings: Option[zio.aws.medialive.model.H265FilterSettings] = None,
    fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = None,
    flickerAq: Option[zio.aws.medialive.model.H265FlickerAq] = None,
    framerateDenominator: __integerMin1Max3003,
    framerateNumerator: __integerMin1,
    gopClosedCadence: Option[__integerMin0] = None,
    gopSize: Option[__double] = None,
    gopSizeUnits: Option[zio.aws.medialive.model.H265GopSizeUnits] = None,
    level: Option[zio.aws.medialive.model.H265Level] = None,
    lookAheadRateControl: Option[
      zio.aws.medialive.model.H265LookAheadRateControl
    ] = None,
    maxBitrate: Option[__integerMin100000Max40000000] = None,
    minIInterval: Option[__integerMin0Max30] = None,
    parDenominator: Option[__integerMin1] = None,
    parNumerator: Option[__integerMin1] = None,
    profile: Option[zio.aws.medialive.model.H265Profile] = None,
    qvbrQualityLevel: Option[__integerMin1Max10] = None,
    rateControlMode: Option[zio.aws.medialive.model.H265RateControlMode] = None,
    scanType: Option[zio.aws.medialive.model.H265ScanType] = None,
    sceneChangeDetect: Option[zio.aws.medialive.model.H265SceneChangeDetect] =
      None,
    slices: Option[__integerMin1Max16] = None,
    tier: Option[zio.aws.medialive.model.H265Tier] = None,
    timecodeInsertion: Option[
      zio.aws.medialive.model.H265TimecodeInsertionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H265Settings = {
    import H265Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H265Settings
      .builder()
      .optionallyWith(adaptiveQuantization.map(value => value.unwrap))(
        _.adaptiveQuantization
      )
      .optionallyWith(afdSignaling.map(value => value.unwrap))(_.afdSignaling)
      .optionallyWith(alternativeTransferFunction.map(value => value.unwrap))(
        _.alternativeTransferFunction
      )
      .optionallyWith(bitrate.map(value => value: Integer))(_.bitrate)
      .optionallyWith(bufSize.map(value => value: Integer))(_.bufSize)
      .optionallyWith(colorMetadata.map(value => value.unwrap))(_.colorMetadata)
      .optionallyWith(colorSpaceSettings.map(value => value.buildAwsValue()))(
        _.colorSpaceSettings
      )
      .optionallyWith(filterSettings.map(value => value.buildAwsValue()))(
        _.filterSettings
      )
      .optionallyWith(fixedAfd.map(value => value.unwrap))(_.fixedAfd)
      .optionallyWith(flickerAq.map(value => value.unwrap))(_.flickerAq)
      .framerateDenominator(framerateDenominator: Integer)
      .framerateNumerator(framerateNumerator: Integer)
      .optionallyWith(gopClosedCadence.map(value => value: Integer))(
        _.gopClosedCadence
      )
      .optionallyWith(gopSize.map(value => value: java.lang.Double))(_.gopSize)
      .optionallyWith(gopSizeUnits.map(value => value.unwrap))(_.gopSizeUnits)
      .optionallyWith(level.map(value => value.unwrap))(_.level)
      .optionallyWith(lookAheadRateControl.map(value => value.unwrap))(
        _.lookAheadRateControl
      )
      .optionallyWith(maxBitrate.map(value => value: Integer))(_.maxBitrate)
      .optionallyWith(minIInterval.map(value => value: Integer))(_.minIInterval)
      .optionallyWith(parDenominator.map(value => value: Integer))(
        _.parDenominator
      )
      .optionallyWith(parNumerator.map(value => value: Integer))(_.parNumerator)
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(qvbrQualityLevel.map(value => value: Integer))(
        _.qvbrQualityLevel
      )
      .optionallyWith(rateControlMode.map(value => value.unwrap))(
        _.rateControlMode
      )
      .optionallyWith(scanType.map(value => value.unwrap))(_.scanType)
      .optionallyWith(sceneChangeDetect.map(value => value.unwrap))(
        _.sceneChangeDetect
      )
      .optionallyWith(slices.map(value => value: Integer))(_.slices)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(timecodeInsertion.map(value => value.unwrap))(
        _.timecodeInsertion
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H265Settings.ReadOnly =
    zio.aws.medialive.model.H265Settings.wrap(buildAwsValue())
}
object H265Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H265Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H265Settings =
      zio.aws.medialive.model.H265Settings(
        adaptiveQuantization.map(value => value),
        afdSignaling.map(value => value),
        alternativeTransferFunction.map(value => value),
        bitrate.map(value => value),
        bufSize.map(value => value),
        colorMetadata.map(value => value),
        colorSpaceSettings.map(value => value.asEditable),
        filterSettings.map(value => value.asEditable),
        fixedAfd.map(value => value),
        flickerAq.map(value => value),
        framerateDenominator,
        framerateNumerator,
        gopClosedCadence.map(value => value),
        gopSize.map(value => value),
        gopSizeUnits.map(value => value),
        level.map(value => value),
        lookAheadRateControl.map(value => value),
        maxBitrate.map(value => value),
        minIInterval.map(value => value),
        parDenominator.map(value => value),
        parNumerator.map(value => value),
        profile.map(value => value),
        qvbrQualityLevel.map(value => value),
        rateControlMode.map(value => value),
        scanType.map(value => value),
        sceneChangeDetect.map(value => value),
        slices.map(value => value),
        tier.map(value => value),
        timecodeInsertion.map(value => value)
      )
    def adaptiveQuantization
        : Option[zio.aws.medialive.model.H265AdaptiveQuantization]
    def afdSignaling: Option[zio.aws.medialive.model.AfdSignaling]
    def alternativeTransferFunction
        : Option[zio.aws.medialive.model.H265AlternativeTransferFunction]
    def bitrate: Option[__integerMin100000Max40000000]
    def bufSize: Option[__integerMin100000Max80000000]
    def colorMetadata: Option[zio.aws.medialive.model.H265ColorMetadata]
    def colorSpaceSettings
        : Option[zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly]
    def filterSettings
        : Option[zio.aws.medialive.model.H265FilterSettings.ReadOnly]
    def fixedAfd: Option[zio.aws.medialive.model.FixedAfd]
    def flickerAq: Option[zio.aws.medialive.model.H265FlickerAq]
    def framerateDenominator: __integerMin1Max3003
    def framerateNumerator: __integerMin1
    def gopClosedCadence: Option[__integerMin0]
    def gopSize: Option[__double]
    def gopSizeUnits: Option[zio.aws.medialive.model.H265GopSizeUnits]
    def level: Option[zio.aws.medialive.model.H265Level]
    def lookAheadRateControl
        : Option[zio.aws.medialive.model.H265LookAheadRateControl]
    def maxBitrate: Option[__integerMin100000Max40000000]
    def minIInterval: Option[__integerMin0Max30]
    def parDenominator: Option[__integerMin1]
    def parNumerator: Option[__integerMin1]
    def profile: Option[zio.aws.medialive.model.H265Profile]
    def qvbrQualityLevel: Option[__integerMin1Max10]
    def rateControlMode: Option[zio.aws.medialive.model.H265RateControlMode]
    def scanType: Option[zio.aws.medialive.model.H265ScanType]
    def sceneChangeDetect: Option[zio.aws.medialive.model.H265SceneChangeDetect]
    def slices: Option[__integerMin1Max16]
    def tier: Option[zio.aws.medialive.model.H265Tier]
    def timecodeInsertion
        : Option[zio.aws.medialive.model.H265TimecodeInsertionBehavior]
    def getAdaptiveQuantization
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265AdaptiveQuantization] =
      AwsError.unwrapOptionField("adaptiveQuantization", adaptiveQuantization)
    def getAfdSignaling
        : ZIO[Any, AwsError, zio.aws.medialive.model.AfdSignaling] =
      AwsError.unwrapOptionField("afdSignaling", afdSignaling)
    def getAlternativeTransferFunction: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H265AlternativeTransferFunction
    ] = AwsError.unwrapOptionField(
      "alternativeTransferFunction",
      alternativeTransferFunction
    )
    def getBitrate: ZIO[Any, AwsError, __integerMin100000Max40000000] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getBufSize: ZIO[Any, AwsError, __integerMin100000Max80000000] =
      AwsError.unwrapOptionField("bufSize", bufSize)
    def getColorMetadata
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265ColorMetadata] =
      AwsError.unwrapOptionField("colorMetadata", colorMetadata)
    def getColorSpaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("colorSpaceSettings", colorSpaceSettings)
    def getFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H265FilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField("filterSettings", filterSettings)
    def getFixedAfd: ZIO[Any, AwsError, zio.aws.medialive.model.FixedAfd] =
      AwsError.unwrapOptionField("fixedAfd", fixedAfd)
    def getFlickerAq
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265FlickerAq] =
      AwsError.unwrapOptionField("flickerAq", flickerAq)
    def getFramerateDenominator: ZIO[Any, Nothing, __integerMin1Max3003] =
      ZIO.succeed(framerateDenominator)
    def getFramerateNumerator: ZIO[Any, Nothing, __integerMin1] =
      ZIO.succeed(framerateNumerator)
    def getGopClosedCadence: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("gopClosedCadence", gopClosedCadence)
    def getGopSize: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("gopSize", gopSize)
    def getGopSizeUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265GopSizeUnits] =
      AwsError.unwrapOptionField("gopSizeUnits", gopSizeUnits)
    def getLevel: ZIO[Any, AwsError, zio.aws.medialive.model.H265Level] =
      AwsError.unwrapOptionField("level", level)
    def getLookAheadRateControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265LookAheadRateControl] =
      AwsError.unwrapOptionField("lookAheadRateControl", lookAheadRateControl)
    def getMaxBitrate: ZIO[Any, AwsError, __integerMin100000Max40000000] =
      AwsError.unwrapOptionField("maxBitrate", maxBitrate)
    def getMinIInterval: ZIO[Any, AwsError, __integerMin0Max30] =
      AwsError.unwrapOptionField("minIInterval", minIInterval)
    def getParDenominator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("parDenominator", parDenominator)
    def getParNumerator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("parNumerator", parNumerator)
    def getProfile: ZIO[Any, AwsError, zio.aws.medialive.model.H265Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getQvbrQualityLevel: ZIO[Any, AwsError, __integerMin1Max10] =
      AwsError.unwrapOptionField("qvbrQualityLevel", qvbrQualityLevel)
    def getRateControlMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265RateControlMode] =
      AwsError.unwrapOptionField("rateControlMode", rateControlMode)
    def getScanType: ZIO[Any, AwsError, zio.aws.medialive.model.H265ScanType] =
      AwsError.unwrapOptionField("scanType", scanType)
    def getSceneChangeDetect
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265SceneChangeDetect] =
      AwsError.unwrapOptionField("sceneChangeDetect", sceneChangeDetect)
    def getSlices: ZIO[Any, AwsError, __integerMin1Max16] =
      AwsError.unwrapOptionField("slices", slices)
    def getTier: ZIO[Any, AwsError, zio.aws.medialive.model.H265Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getTimecodeInsertion: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H265TimecodeInsertionBehavior
    ] = AwsError.unwrapOptionField("timecodeInsertion", timecodeInsertion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H265Settings
  ) extends zio.aws.medialive.model.H265Settings.ReadOnly {
    override val adaptiveQuantization
        : Option[zio.aws.medialive.model.H265AdaptiveQuantization] = scala
      .Option(impl.adaptiveQuantization())
      .map(value =>
        zio.aws.medialive.model.H265AdaptiveQuantization.wrap(value)
      )
    override val afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] =
      scala
        .Option(impl.afdSignaling())
        .map(value => zio.aws.medialive.model.AfdSignaling.wrap(value))
    override val alternativeTransferFunction
        : Option[zio.aws.medialive.model.H265AlternativeTransferFunction] =
      scala
        .Option(impl.alternativeTransferFunction())
        .map(value =>
          zio.aws.medialive.model.H265AlternativeTransferFunction.wrap(value)
        )
    override val bitrate: Option[__integerMin100000Max40000000] = scala
      .Option(impl.bitrate())
      .map(value => value: __integerMin100000Max40000000)
    override val bufSize: Option[__integerMin100000Max80000000] = scala
      .Option(impl.bufSize())
      .map(value => value: __integerMin100000Max80000000)
    override val colorMetadata
        : Option[zio.aws.medialive.model.H265ColorMetadata] = scala
      .Option(impl.colorMetadata())
      .map(value => zio.aws.medialive.model.H265ColorMetadata.wrap(value))
    override val colorSpaceSettings
        : Option[zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly] =
      scala
        .Option(impl.colorSpaceSettings())
        .map(value =>
          zio.aws.medialive.model.H265ColorSpaceSettings.wrap(value)
        )
    override val filterSettings
        : Option[zio.aws.medialive.model.H265FilterSettings.ReadOnly] = scala
      .Option(impl.filterSettings())
      .map(value => zio.aws.medialive.model.H265FilterSettings.wrap(value))
    override val fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = scala
      .Option(impl.fixedAfd())
      .map(value => zio.aws.medialive.model.FixedAfd.wrap(value))
    override val flickerAq: Option[zio.aws.medialive.model.H265FlickerAq] =
      scala
        .Option(impl.flickerAq())
        .map(value => zio.aws.medialive.model.H265FlickerAq.wrap(value))
    override val framerateDenominator: __integerMin1Max3003 =
      impl.framerateDenominator(): __integerMin1Max3003
    override val framerateNumerator: __integerMin1 =
      impl.framerateNumerator(): __integerMin1
    override val gopClosedCadence: Option[__integerMin0] =
      scala.Option(impl.gopClosedCadence()).map(value => value: __integerMin0)
    override val gopSize: Option[__double] =
      scala.Option(impl.gopSize()).map(value => value: __double)
    override val gopSizeUnits
        : Option[zio.aws.medialive.model.H265GopSizeUnits] = scala
      .Option(impl.gopSizeUnits())
      .map(value => zio.aws.medialive.model.H265GopSizeUnits.wrap(value))
    override val level: Option[zio.aws.medialive.model.H265Level] = scala
      .Option(impl.level())
      .map(value => zio.aws.medialive.model.H265Level.wrap(value))
    override val lookAheadRateControl
        : Option[zio.aws.medialive.model.H265LookAheadRateControl] = scala
      .Option(impl.lookAheadRateControl())
      .map(value =>
        zio.aws.medialive.model.H265LookAheadRateControl.wrap(value)
      )
    override val maxBitrate: Option[__integerMin100000Max40000000] = scala
      .Option(impl.maxBitrate())
      .map(value => value: __integerMin100000Max40000000)
    override val minIInterval: Option[__integerMin0Max30] =
      scala.Option(impl.minIInterval()).map(value => value: __integerMin0Max30)
    override val parDenominator: Option[__integerMin1] =
      scala.Option(impl.parDenominator()).map(value => value: __integerMin1)
    override val parNumerator: Option[__integerMin1] =
      scala.Option(impl.parNumerator()).map(value => value: __integerMin1)
    override val profile: Option[zio.aws.medialive.model.H265Profile] = scala
      .Option(impl.profile())
      .map(value => zio.aws.medialive.model.H265Profile.wrap(value))
    override val qvbrQualityLevel: Option[__integerMin1Max10] = scala
      .Option(impl.qvbrQualityLevel())
      .map(value => value: __integerMin1Max10)
    override val rateControlMode
        : Option[zio.aws.medialive.model.H265RateControlMode] = scala
      .Option(impl.rateControlMode())
      .map(value => zio.aws.medialive.model.H265RateControlMode.wrap(value))
    override val scanType: Option[zio.aws.medialive.model.H265ScanType] = scala
      .Option(impl.scanType())
      .map(value => zio.aws.medialive.model.H265ScanType.wrap(value))
    override val sceneChangeDetect
        : Option[zio.aws.medialive.model.H265SceneChangeDetect] = scala
      .Option(impl.sceneChangeDetect())
      .map(value => zio.aws.medialive.model.H265SceneChangeDetect.wrap(value))
    override val slices: Option[__integerMin1Max16] =
      scala.Option(impl.slices()).map(value => value: __integerMin1Max16)
    override val tier: Option[zio.aws.medialive.model.H265Tier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.medialive.model.H265Tier.wrap(value))
    override val timecodeInsertion
        : Option[zio.aws.medialive.model.H265TimecodeInsertionBehavior] = scala
      .Option(impl.timecodeInsertion())
      .map(value =>
        zio.aws.medialive.model.H265TimecodeInsertionBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H265Settings
  ): zio.aws.medialive.model.H265Settings.ReadOnly = new Wrapper(impl)
}
