package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265Tier {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265Tier
}
object H265Tier {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265Tier
  ): zio.aws.medialive.model.H265Tier = value match {
    case software.amazon.awssdk.services.medialive.model.H265Tier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265Tier.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.medialive.model.H265Tier.MAIN =>
      val r = MAIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H265Tier {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Tier =
      software.amazon.awssdk.services.medialive.model.H265Tier.UNKNOWN_TO_SDK_VERSION
  }
  case object HIGH extends zio.aws.medialive.model.H265Tier {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Tier =
      software.amazon.awssdk.services.medialive.model.H265Tier.HIGH
  }
  case object MAIN extends zio.aws.medialive.model.H265Tier {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Tier =
      software.amazon.awssdk.services.medialive.model.H265Tier.MAIN
  }
}
