package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265TimecodeInsertionBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior
}
object H265TimecodeInsertionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior
  ): zio.aws.medialive.model.H265TimecodeInsertionBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.PIC_TIMING_SEI =>
      val r = PIC_TIMING_SEI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.medialive.model.H265TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.DISABLED
  }
  case object PIC_TIMING_SEI
      extends zio.aws.medialive.model.H265TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior.PIC_TIMING_SEI
  }
}
