package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0Max32768
import scala.jdk.CollectionConverters._
final case class Hdr10Settings(
    maxCll: Option[__integerMin0Max32768] = None,
    maxFall: Option[__integerMin0Max32768] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Hdr10Settings = {
    import Hdr10Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Hdr10Settings
      .builder()
      .optionallyWith(maxCll.map(value => value: Integer))(_.maxCll)
      .optionallyWith(maxFall.map(value => value: Integer))(_.maxFall)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Hdr10Settings.ReadOnly =
    zio.aws.medialive.model.Hdr10Settings.wrap(buildAwsValue())
}
object Hdr10Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Hdr10Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Hdr10Settings =
      zio.aws.medialive.model
        .Hdr10Settings(maxCll.map(value => value), maxFall.map(value => value))
    def maxCll: Option[__integerMin0Max32768]
    def maxFall: Option[__integerMin0Max32768]
    def getMaxCll: ZIO[Any, AwsError, __integerMin0Max32768] =
      AwsError.unwrapOptionField("maxCll", maxCll)
    def getMaxFall: ZIO[Any, AwsError, __integerMin0Max32768] =
      AwsError.unwrapOptionField("maxFall", maxFall)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Hdr10Settings
  ) extends zio.aws.medialive.model.Hdr10Settings.ReadOnly {
    override val maxCll: Option[__integerMin0Max32768] =
      scala.Option(impl.maxCll()).map(value => value: __integerMin0Max32768)
    override val maxFall: Option[__integerMin0Max32768] =
      scala.Option(impl.maxFall()).map(value => value: __integerMin0Max32768)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Hdr10Settings
  ): zio.aws.medialive.model.Hdr10Settings.ReadOnly = new Wrapper(impl)
}
