package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsAdMarkers {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsAdMarkers
}
object HlsAdMarkers {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsAdMarkers
  ): zio.aws.medialive.model.HlsAdMarkers = value match {
    case software.amazon.awssdk.services.medialive.model.HlsAdMarkers.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ADOBE =>
      val r = ADOBE
      r
    case software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ELEMENTAL =>
      val r = ELEMENTAL
      r
    case software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ELEMENTAL_SCTE35 =>
      val r = ELEMENTAL_SCTE35
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.HlsAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAdMarkers =
      software.amazon.awssdk.services.medialive.model.HlsAdMarkers.UNKNOWN_TO_SDK_VERSION
  }
  case object ADOBE extends zio.aws.medialive.model.HlsAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAdMarkers =
      software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ADOBE
  }
  case object ELEMENTAL extends zio.aws.medialive.model.HlsAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAdMarkers =
      software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ELEMENTAL
  }
  case object ELEMENTAL_SCTE35 extends zio.aws.medialive.model.HlsAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAdMarkers =
      software.amazon.awssdk.services.medialive.model.HlsAdMarkers.ELEMENTAL_SCTE35
  }
}
