package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsAkamaiHttpTransferMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode
}
object HlsAkamaiHttpTransferMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode
  ): zio.aws.medialive.model.HlsAkamaiHttpTransferMode = value match {
    case software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.CHUNKED =>
      val r = CHUNKED
      r
    case software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.NON_CHUNKED =>
      val r = NON_CHUNKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsAkamaiHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CHUNKED
      extends zio.aws.medialive.model.HlsAkamaiHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.CHUNKED
  }
  case object NON_CHUNKED
      extends zio.aws.medialive.model.HlsAkamaiHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode.NON_CHUNKED
  }
}
