package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __string,
  __integerMin0Max15,
  __integerMin0Max600,
  __integerMin0
}
import scala.jdk.CollectionConverters._
final case class HlsAkamaiSettings(
    connectionRetryInterval: Option[__integerMin0] = None,
    filecacheDuration: Option[__integerMin0Max600] = None,
    httpTransferMode: Option[
      zio.aws.medialive.model.HlsAkamaiHttpTransferMode
    ] = None,
    numRetries: Option[__integerMin0] = None,
    restartDelay: Option[__integerMin0Max15] = None,
    salt: Option[__string] = None,
    token: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings = {
    import HlsAkamaiSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings
      .builder()
      .optionallyWith(connectionRetryInterval.map(value => value: Integer))(
        _.connectionRetryInterval
      )
      .optionallyWith(filecacheDuration.map(value => value: Integer))(
        _.filecacheDuration
      )
      .optionallyWith(httpTransferMode.map(value => value.unwrap))(
        _.httpTransferMode
      )
      .optionallyWith(numRetries.map(value => value: Integer))(_.numRetries)
      .optionallyWith(restartDelay.map(value => value: Integer))(_.restartDelay)
      .optionallyWith(salt.map(value => value: java.lang.String))(_.salt)
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly =
    zio.aws.medialive.model.HlsAkamaiSettings.wrap(buildAwsValue())
}
object HlsAkamaiSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsAkamaiSettings =
      zio.aws.medialive.model.HlsAkamaiSettings(
        connectionRetryInterval.map(value => value),
        filecacheDuration.map(value => value),
        httpTransferMode.map(value => value),
        numRetries.map(value => value),
        restartDelay.map(value => value),
        salt.map(value => value),
        token.map(value => value)
      )
    def connectionRetryInterval: Option[__integerMin0]
    def filecacheDuration: Option[__integerMin0Max600]
    def httpTransferMode
        : Option[zio.aws.medialive.model.HlsAkamaiHttpTransferMode]
    def numRetries: Option[__integerMin0]
    def restartDelay: Option[__integerMin0Max15]
    def salt: Option[__string]
    def token: Option[__string]
    def getConnectionRetryInterval: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("connectionRetryInterval", connectionRetryInterval)
    def getFilecacheDuration: ZIO[Any, AwsError, __integerMin0Max600] =
      AwsError.unwrapOptionField("filecacheDuration", filecacheDuration)
    def getHttpTransferMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsAkamaiHttpTransferMode
    ] = AwsError.unwrapOptionField("httpTransferMode", httpTransferMode)
    def getNumRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("numRetries", numRetries)
    def getRestartDelay: ZIO[Any, AwsError, __integerMin0Max15] =
      AwsError.unwrapOptionField("restartDelay", restartDelay)
    def getSalt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("salt", salt)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings
  ) extends zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly {
    override val connectionRetryInterval: Option[__integerMin0] = scala
      .Option(impl.connectionRetryInterval())
      .map(value => value: __integerMin0)
    override val filecacheDuration: Option[__integerMin0Max600] = scala
      .Option(impl.filecacheDuration())
      .map(value => value: __integerMin0Max600)
    override val httpTransferMode
        : Option[zio.aws.medialive.model.HlsAkamaiHttpTransferMode] = scala
      .Option(impl.httpTransferMode())
      .map(value =>
        zio.aws.medialive.model.HlsAkamaiHttpTransferMode.wrap(value)
      )
    override val numRetries: Option[__integerMin0] =
      scala.Option(impl.numRetries()).map(value => value: __integerMin0)
    override val restartDelay: Option[__integerMin0Max15] =
      scala.Option(impl.restartDelay()).map(value => value: __integerMin0Max15)
    override val salt: Option[__string] =
      scala.Option(impl.salt()).map(value => value: __string)
    override val token: Option[__string] =
      scala.Option(impl.token()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings
  ): zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly = new Wrapper(impl)
}
