package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max15,
  __integerMin0Max600,
  __integerMin0
}
import scala.jdk.CollectionConverters._
final case class HlsBasicPutSettings(
    connectionRetryInterval: Option[__integerMin0] = None,
    filecacheDuration: Option[__integerMin0Max600] = None,
    numRetries: Option[__integerMin0] = None,
    restartDelay: Option[__integerMin0Max15] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings = {
    import HlsBasicPutSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings
      .builder()
      .optionallyWith(connectionRetryInterval.map(value => value: Integer))(
        _.connectionRetryInterval
      )
      .optionallyWith(filecacheDuration.map(value => value: Integer))(
        _.filecacheDuration
      )
      .optionallyWith(numRetries.map(value => value: Integer))(_.numRetries)
      .optionallyWith(restartDelay.map(value => value: Integer))(_.restartDelay)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly =
    zio.aws.medialive.model.HlsBasicPutSettings.wrap(buildAwsValue())
}
object HlsBasicPutSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsBasicPutSettings =
      zio.aws.medialive.model.HlsBasicPutSettings(
        connectionRetryInterval.map(value => value),
        filecacheDuration.map(value => value),
        numRetries.map(value => value),
        restartDelay.map(value => value)
      )
    def connectionRetryInterval: Option[__integerMin0]
    def filecacheDuration: Option[__integerMin0Max600]
    def numRetries: Option[__integerMin0]
    def restartDelay: Option[__integerMin0Max15]
    def getConnectionRetryInterval: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("connectionRetryInterval", connectionRetryInterval)
    def getFilecacheDuration: ZIO[Any, AwsError, __integerMin0Max600] =
      AwsError.unwrapOptionField("filecacheDuration", filecacheDuration)
    def getNumRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("numRetries", numRetries)
    def getRestartDelay: ZIO[Any, AwsError, __integerMin0Max15] =
      AwsError.unwrapOptionField("restartDelay", restartDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings
  ) extends zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly {
    override val connectionRetryInterval: Option[__integerMin0] = scala
      .Option(impl.connectionRetryInterval())
      .map(value => value: __integerMin0)
    override val filecacheDuration: Option[__integerMin0Max600] = scala
      .Option(impl.filecacheDuration())
      .map(value => value: __integerMin0Max600)
    override val numRetries: Option[__integerMin0] =
      scala.Option(impl.numRetries()).map(value => value: __integerMin0)
    override val restartDelay: Option[__integerMin0Max15] =
      scala.Option(impl.restartDelay()).map(value => value: __integerMin0Max15)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings
  ): zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly = new Wrapper(impl)
}
