package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HlsCdnSettings(
    hlsAkamaiSettings: Option[zio.aws.medialive.model.HlsAkamaiSettings] = None,
    hlsBasicPutSettings: Option[zio.aws.medialive.model.HlsBasicPutSettings] =
      None,
    hlsMediaStoreSettings: Option[
      zio.aws.medialive.model.HlsMediaStoreSettings
    ] = None,
    hlsS3Settings: Option[zio.aws.medialive.model.HlsS3Settings] = None,
    hlsWebdavSettings: Option[zio.aws.medialive.model.HlsWebdavSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsCdnSettings = {
    import HlsCdnSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsCdnSettings
      .builder()
      .optionallyWith(hlsAkamaiSettings.map(value => value.buildAwsValue()))(
        _.hlsAkamaiSettings
      )
      .optionallyWith(hlsBasicPutSettings.map(value => value.buildAwsValue()))(
        _.hlsBasicPutSettings
      )
      .optionallyWith(
        hlsMediaStoreSettings.map(value => value.buildAwsValue())
      )(_.hlsMediaStoreSettings)
      .optionallyWith(hlsS3Settings.map(value => value.buildAwsValue()))(
        _.hlsS3Settings
      )
      .optionallyWith(hlsWebdavSettings.map(value => value.buildAwsValue()))(
        _.hlsWebdavSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsCdnSettings.ReadOnly =
    zio.aws.medialive.model.HlsCdnSettings.wrap(buildAwsValue())
}
object HlsCdnSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsCdnSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsCdnSettings =
      zio.aws.medialive.model.HlsCdnSettings(
        hlsAkamaiSettings.map(value => value.asEditable),
        hlsBasicPutSettings.map(value => value.asEditable),
        hlsMediaStoreSettings.map(value => value.asEditable),
        hlsS3Settings.map(value => value.asEditable),
        hlsWebdavSettings.map(value => value.asEditable)
      )
    def hlsAkamaiSettings
        : Option[zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly]
    def hlsBasicPutSettings
        : Option[zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly]
    def hlsMediaStoreSettings
        : Option[zio.aws.medialive.model.HlsMediaStoreSettings.ReadOnly]
    def hlsS3Settings: Option[zio.aws.medialive.model.HlsS3Settings.ReadOnly]
    def hlsWebdavSettings
        : Option[zio.aws.medialive.model.HlsWebdavSettings.ReadOnly]
    def getHlsAkamaiSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsAkamaiSettings", hlsAkamaiSettings)
    def getHlsBasicPutSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsBasicPutSettings", hlsBasicPutSettings)
    def getHlsMediaStoreSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsMediaStoreSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("hlsMediaStoreSettings", hlsMediaStoreSettings)
    def getHlsS3Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsS3Settings.ReadOnly] =
      AwsError.unwrapOptionField("hlsS3Settings", hlsS3Settings)
    def getHlsWebdavSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsWebdavSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsWebdavSettings", hlsWebdavSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsCdnSettings
  ) extends zio.aws.medialive.model.HlsCdnSettings.ReadOnly {
    override val hlsAkamaiSettings
        : Option[zio.aws.medialive.model.HlsAkamaiSettings.ReadOnly] = scala
      .Option(impl.hlsAkamaiSettings())
      .map(value => zio.aws.medialive.model.HlsAkamaiSettings.wrap(value))
    override val hlsBasicPutSettings
        : Option[zio.aws.medialive.model.HlsBasicPutSettings.ReadOnly] = scala
      .Option(impl.hlsBasicPutSettings())
      .map(value => zio.aws.medialive.model.HlsBasicPutSettings.wrap(value))
    override val hlsMediaStoreSettings
        : Option[zio.aws.medialive.model.HlsMediaStoreSettings.ReadOnly] = scala
      .Option(impl.hlsMediaStoreSettings())
      .map(value => zio.aws.medialive.model.HlsMediaStoreSettings.wrap(value))
    override val hlsS3Settings
        : Option[zio.aws.medialive.model.HlsS3Settings.ReadOnly] = scala
      .Option(impl.hlsS3Settings())
      .map(value => zio.aws.medialive.model.HlsS3Settings.wrap(value))
    override val hlsWebdavSettings
        : Option[zio.aws.medialive.model.HlsWebdavSettings.ReadOnly] = scala
      .Option(impl.hlsWebdavSettings())
      .map(value => zio.aws.medialive.model.HlsWebdavSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsCdnSettings
  ): zio.aws.medialive.model.HlsCdnSettings.ReadOnly = new Wrapper(impl)
}
