package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsClientCache {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsClientCache
}
object HlsClientCache {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsClientCache
  ): zio.aws.medialive.model.HlsClientCache = value match {
    case software.amazon.awssdk.services.medialive.model.HlsClientCache.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsClientCache.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.HlsClientCache.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsClientCache {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsClientCache =
      software.amazon.awssdk.services.medialive.model.HlsClientCache.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.HlsClientCache {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsClientCache =
      software.amazon.awssdk.services.medialive.model.HlsClientCache.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.HlsClientCache {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsClientCache =
      software.amazon.awssdk.services.medialive.model.HlsClientCache.ENABLED
  }
}
