package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsCodecSpecification {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsCodecSpecification
}
object HlsCodecSpecification {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsCodecSpecification
  ): zio.aws.medialive.model.HlsCodecSpecification = value match {
    case software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.RFC_4281 =>
      val r = RFC_4281
      r
    case software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.RFC_6381 =>
      val r = RFC_6381
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsCodecSpecification {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsCodecSpecification =
      software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.UNKNOWN_TO_SDK_VERSION
  }
  case object RFC_4281 extends zio.aws.medialive.model.HlsCodecSpecification {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsCodecSpecification =
      software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.RFC_4281
  }
  case object RFC_6381 extends zio.aws.medialive.model.HlsCodecSpecification {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsCodecSpecification =
      software.amazon.awssdk.services.medialive.model.HlsCodecSpecification.RFC_6381
  }
}
