package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsDirectoryStructure {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure
}
object HlsDirectoryStructure {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure
  ): zio.aws.medialive.model.HlsDirectoryStructure = value match {
    case software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.SINGLE_DIRECTORY =>
      val r = SINGLE_DIRECTORY
      r
    case software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.SUBDIRECTORY_PER_STREAM =>
      val r = SUBDIRECTORY_PER_STREAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsDirectoryStructure {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure =
      software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE_DIRECTORY
      extends zio.aws.medialive.model.HlsDirectoryStructure {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure =
      software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.SINGLE_DIRECTORY
  }
  case object SUBDIRECTORY_PER_STREAM
      extends zio.aws.medialive.model.HlsDirectoryStructure {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure =
      software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure.SUBDIRECTORY_PER_STREAM
  }
}
