package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsDiscontinuityTags {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags
}
object HlsDiscontinuityTags {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags
  ): zio.aws.medialive.model.HlsDiscontinuityTags = value match {
    case software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.NEVER_INSERT =>
      val r = NEVER_INSERT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsDiscontinuityTags {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags =
      software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.UNKNOWN_TO_SDK_VERSION
  }
  case object INSERT extends zio.aws.medialive.model.HlsDiscontinuityTags {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags =
      software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.INSERT
  }
  case object NEVER_INSERT
      extends zio.aws.medialive.model.HlsDiscontinuityTags {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags =
      software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags.NEVER_INSERT
  }
}
