package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsEncryptionType {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsEncryptionType
}
object HlsEncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsEncryptionType
  ): zio.aws.medialive.model.HlsEncryptionType = value match {
    case software.amazon.awssdk.services.medialive.model.HlsEncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsEncryptionType.AES128 =>
      val r = AES128
      r
    case software.amazon.awssdk.services.medialive.model.HlsEncryptionType.SAMPLE_AES =>
      val r = SAMPLE_AES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsEncryptionType =
      software.amazon.awssdk.services.medialive.model.HlsEncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object AES128 extends zio.aws.medialive.model.HlsEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsEncryptionType =
      software.amazon.awssdk.services.medialive.model.HlsEncryptionType.AES128
  }
  case object SAMPLE_AES extends zio.aws.medialive.model.HlsEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsEncryptionType =
      software.amazon.awssdk.services.medialive.model.HlsEncryptionType.SAMPLE_AES
  }
}
