package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0,
  __string,
  __integerMin1,
  __stringMin32Max32,
  __integerMin0Max3600,
  __integerMin3
}
import scala.jdk.CollectionConverters._
final case class HlsGroupSettings(
    adMarkers: Option[Iterable[zio.aws.medialive.model.HlsAdMarkers]] = None,
    baseUrlContent: Option[__string] = None,
    baseUrlContent1: Option[__string] = None,
    baseUrlManifest: Option[__string] = None,
    baseUrlManifest1: Option[__string] = None,
    captionLanguageMappings: Option[
      Iterable[zio.aws.medialive.model.CaptionLanguageMapping]
    ] = None,
    captionLanguageSetting: Option[
      zio.aws.medialive.model.HlsCaptionLanguageSetting
    ] = None,
    clientCache: Option[zio.aws.medialive.model.HlsClientCache] = None,
    codecSpecification: Option[zio.aws.medialive.model.HlsCodecSpecification] =
      None,
    constantIv: Option[__stringMin32Max32] = None,
    destination: zio.aws.medialive.model.OutputLocationRef,
    directoryStructure: Option[zio.aws.medialive.model.HlsDirectoryStructure] =
      None,
    discontinuityTags: Option[zio.aws.medialive.model.HlsDiscontinuityTags] =
      None,
    encryptionType: Option[zio.aws.medialive.model.HlsEncryptionType] = None,
    hlsCdnSettings: Option[zio.aws.medialive.model.HlsCdnSettings] = None,
    hlsId3SegmentTagging: Option[
      zio.aws.medialive.model.HlsId3SegmentTaggingState
    ] = None,
    iFrameOnlyPlaylists: Option[
      zio.aws.medialive.model.IFrameOnlyPlaylistType
    ] = None,
    incompleteSegmentBehavior: Option[
      zio.aws.medialive.model.HlsIncompleteSegmentBehavior
    ] = None,
    indexNSegments: Option[__integerMin3] = None,
    inputLossAction: Option[zio.aws.medialive.model.InputLossActionForHlsOut] =
      None,
    ivInManifest: Option[zio.aws.medialive.model.HlsIvInManifest] = None,
    ivSource: Option[zio.aws.medialive.model.HlsIvSource] = None,
    keepSegments: Option[__integerMin1] = None,
    keyFormat: Option[__string] = None,
    keyFormatVersions: Option[__string] = None,
    keyProviderSettings: Option[zio.aws.medialive.model.KeyProviderSettings] =
      None,
    manifestCompression: Option[
      zio.aws.medialive.model.HlsManifestCompression
    ] = None,
    manifestDurationFormat: Option[
      zio.aws.medialive.model.HlsManifestDurationFormat
    ] = None,
    minSegmentLength: Option[__integerMin0] = None,
    mode: Option[zio.aws.medialive.model.HlsMode] = None,
    outputSelection: Option[zio.aws.medialive.model.HlsOutputSelection] = None,
    programDateTime: Option[zio.aws.medialive.model.HlsProgramDateTime] = None,
    programDateTimeClock: Option[
      zio.aws.medialive.model.HlsProgramDateTimeClock
    ] = None,
    programDateTimePeriod: Option[__integerMin0Max3600] = None,
    redundantManifest: Option[zio.aws.medialive.model.HlsRedundantManifest] =
      None,
    segmentLength: Option[__integerMin1] = None,
    segmentationMode: Option[zio.aws.medialive.model.HlsSegmentationMode] =
      None,
    segmentsPerSubdirectory: Option[__integerMin1] = None,
    streamInfResolution: Option[
      zio.aws.medialive.model.HlsStreamInfResolution
    ] = None,
    timedMetadataId3Frame: Option[
      zio.aws.medialive.model.HlsTimedMetadataId3Frame
    ] = None,
    timedMetadataId3Period: Option[__integerMin0] = None,
    timestampDeltaMilliseconds: Option[__integerMin0] = None,
    tsFileMode: Option[zio.aws.medialive.model.HlsTsFileMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsGroupSettings = {
    import HlsGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsGroupSettings
      .builder()
      .optionallyWith(
        adMarkers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adMarkersWithStrings)
      .optionallyWith(baseUrlContent.map(value => value: java.lang.String))(
        _.baseUrlContent
      )
      .optionallyWith(baseUrlContent1.map(value => value: java.lang.String))(
        _.baseUrlContent1
      )
      .optionallyWith(baseUrlManifest.map(value => value: java.lang.String))(
        _.baseUrlManifest
      )
      .optionallyWith(baseUrlManifest1.map(value => value: java.lang.String))(
        _.baseUrlManifest1
      )
      .optionallyWith(
        captionLanguageMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionLanguageMappings)
      .optionallyWith(captionLanguageSetting.map(value => value.unwrap))(
        _.captionLanguageSetting
      )
      .optionallyWith(clientCache.map(value => value.unwrap))(_.clientCache)
      .optionallyWith(codecSpecification.map(value => value.unwrap))(
        _.codecSpecification
      )
      .optionallyWith(constantIv.map(value => value: java.lang.String))(
        _.constantIv
      )
      .destination(destination.buildAwsValue())
      .optionallyWith(directoryStructure.map(value => value.unwrap))(
        _.directoryStructure
      )
      .optionallyWith(discontinuityTags.map(value => value.unwrap))(
        _.discontinuityTags
      )
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .optionallyWith(hlsCdnSettings.map(value => value.buildAwsValue()))(
        _.hlsCdnSettings
      )
      .optionallyWith(hlsId3SegmentTagging.map(value => value.unwrap))(
        _.hlsId3SegmentTagging
      )
      .optionallyWith(iFrameOnlyPlaylists.map(value => value.unwrap))(
        _.iFrameOnlyPlaylists
      )
      .optionallyWith(incompleteSegmentBehavior.map(value => value.unwrap))(
        _.incompleteSegmentBehavior
      )
      .optionallyWith(indexNSegments.map(value => value: Integer))(
        _.indexNSegments
      )
      .optionallyWith(inputLossAction.map(value => value.unwrap))(
        _.inputLossAction
      )
      .optionallyWith(ivInManifest.map(value => value.unwrap))(_.ivInManifest)
      .optionallyWith(ivSource.map(value => value.unwrap))(_.ivSource)
      .optionallyWith(keepSegments.map(value => value: Integer))(_.keepSegments)
      .optionallyWith(keyFormat.map(value => value: java.lang.String))(
        _.keyFormat
      )
      .optionallyWith(keyFormatVersions.map(value => value: java.lang.String))(
        _.keyFormatVersions
      )
      .optionallyWith(keyProviderSettings.map(value => value.buildAwsValue()))(
        _.keyProviderSettings
      )
      .optionallyWith(manifestCompression.map(value => value.unwrap))(
        _.manifestCompression
      )
      .optionallyWith(manifestDurationFormat.map(value => value.unwrap))(
        _.manifestDurationFormat
      )
      .optionallyWith(minSegmentLength.map(value => value: Integer))(
        _.minSegmentLength
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(outputSelection.map(value => value.unwrap))(
        _.outputSelection
      )
      .optionallyWith(programDateTime.map(value => value.unwrap))(
        _.programDateTime
      )
      .optionallyWith(programDateTimeClock.map(value => value.unwrap))(
        _.programDateTimeClock
      )
      .optionallyWith(programDateTimePeriod.map(value => value: Integer))(
        _.programDateTimePeriod
      )
      .optionallyWith(redundantManifest.map(value => value.unwrap))(
        _.redundantManifest
      )
      .optionallyWith(segmentLength.map(value => value: Integer))(
        _.segmentLength
      )
      .optionallyWith(segmentationMode.map(value => value.unwrap))(
        _.segmentationMode
      )
      .optionallyWith(segmentsPerSubdirectory.map(value => value: Integer))(
        _.segmentsPerSubdirectory
      )
      .optionallyWith(streamInfResolution.map(value => value.unwrap))(
        _.streamInfResolution
      )
      .optionallyWith(timedMetadataId3Frame.map(value => value.unwrap))(
        _.timedMetadataId3Frame
      )
      .optionallyWith(timedMetadataId3Period.map(value => value: Integer))(
        _.timedMetadataId3Period
      )
      .optionallyWith(timestampDeltaMilliseconds.map(value => value: Integer))(
        _.timestampDeltaMilliseconds
      )
      .optionallyWith(tsFileMode.map(value => value.unwrap))(_.tsFileMode)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsGroupSettings.ReadOnly =
    zio.aws.medialive.model.HlsGroupSettings.wrap(buildAwsValue())
}
object HlsGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsGroupSettings =
      zio.aws.medialive.model.HlsGroupSettings(
        adMarkers.map(value => value),
        baseUrlContent.map(value => value),
        baseUrlContent1.map(value => value),
        baseUrlManifest.map(value => value),
        baseUrlManifest1.map(value => value),
        captionLanguageMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captionLanguageSetting.map(value => value),
        clientCache.map(value => value),
        codecSpecification.map(value => value),
        constantIv.map(value => value),
        destination.asEditable,
        directoryStructure.map(value => value),
        discontinuityTags.map(value => value),
        encryptionType.map(value => value),
        hlsCdnSettings.map(value => value.asEditable),
        hlsId3SegmentTagging.map(value => value),
        iFrameOnlyPlaylists.map(value => value),
        incompleteSegmentBehavior.map(value => value),
        indexNSegments.map(value => value),
        inputLossAction.map(value => value),
        ivInManifest.map(value => value),
        ivSource.map(value => value),
        keepSegments.map(value => value),
        keyFormat.map(value => value),
        keyFormatVersions.map(value => value),
        keyProviderSettings.map(value => value.asEditable),
        manifestCompression.map(value => value),
        manifestDurationFormat.map(value => value),
        minSegmentLength.map(value => value),
        mode.map(value => value),
        outputSelection.map(value => value),
        programDateTime.map(value => value),
        programDateTimeClock.map(value => value),
        programDateTimePeriod.map(value => value),
        redundantManifest.map(value => value),
        segmentLength.map(value => value),
        segmentationMode.map(value => value),
        segmentsPerSubdirectory.map(value => value),
        streamInfResolution.map(value => value),
        timedMetadataId3Frame.map(value => value),
        timedMetadataId3Period.map(value => value),
        timestampDeltaMilliseconds.map(value => value),
        tsFileMode.map(value => value)
      )
    def adMarkers: Option[List[zio.aws.medialive.model.HlsAdMarkers]]
    def baseUrlContent: Option[__string]
    def baseUrlContent1: Option[__string]
    def baseUrlManifest: Option[__string]
    def baseUrlManifest1: Option[__string]
    def captionLanguageMappings
        : Option[List[zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly]]
    def captionLanguageSetting
        : Option[zio.aws.medialive.model.HlsCaptionLanguageSetting]
    def clientCache: Option[zio.aws.medialive.model.HlsClientCache]
    def codecSpecification
        : Option[zio.aws.medialive.model.HlsCodecSpecification]
    def constantIv: Option[__stringMin32Max32]
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def directoryStructure
        : Option[zio.aws.medialive.model.HlsDirectoryStructure]
    def discontinuityTags: Option[zio.aws.medialive.model.HlsDiscontinuityTags]
    def encryptionType: Option[zio.aws.medialive.model.HlsEncryptionType]
    def hlsCdnSettings: Option[zio.aws.medialive.model.HlsCdnSettings.ReadOnly]
    def hlsId3SegmentTagging
        : Option[zio.aws.medialive.model.HlsId3SegmentTaggingState]
    def iFrameOnlyPlaylists
        : Option[zio.aws.medialive.model.IFrameOnlyPlaylistType]
    def incompleteSegmentBehavior
        : Option[zio.aws.medialive.model.HlsIncompleteSegmentBehavior]
    def indexNSegments: Option[__integerMin3]
    def inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForHlsOut]
    def ivInManifest: Option[zio.aws.medialive.model.HlsIvInManifest]
    def ivSource: Option[zio.aws.medialive.model.HlsIvSource]
    def keepSegments: Option[__integerMin1]
    def keyFormat: Option[__string]
    def keyFormatVersions: Option[__string]
    def keyProviderSettings
        : Option[zio.aws.medialive.model.KeyProviderSettings.ReadOnly]
    def manifestCompression
        : Option[zio.aws.medialive.model.HlsManifestCompression]
    def manifestDurationFormat
        : Option[zio.aws.medialive.model.HlsManifestDurationFormat]
    def minSegmentLength: Option[__integerMin0]
    def mode: Option[zio.aws.medialive.model.HlsMode]
    def outputSelection: Option[zio.aws.medialive.model.HlsOutputSelection]
    def programDateTime: Option[zio.aws.medialive.model.HlsProgramDateTime]
    def programDateTimeClock
        : Option[zio.aws.medialive.model.HlsProgramDateTimeClock]
    def programDateTimePeriod: Option[__integerMin0Max3600]
    def redundantManifest: Option[zio.aws.medialive.model.HlsRedundantManifest]
    def segmentLength: Option[__integerMin1]
    def segmentationMode: Option[zio.aws.medialive.model.HlsSegmentationMode]
    def segmentsPerSubdirectory: Option[__integerMin1]
    def streamInfResolution
        : Option[zio.aws.medialive.model.HlsStreamInfResolution]
    def timedMetadataId3Frame
        : Option[zio.aws.medialive.model.HlsTimedMetadataId3Frame]
    def timedMetadataId3Period: Option[__integerMin0]
    def timestampDeltaMilliseconds: Option[__integerMin0]
    def tsFileMode: Option[zio.aws.medialive.model.HlsTsFileMode]
    def getAdMarkers
        : ZIO[Any, AwsError, List[zio.aws.medialive.model.HlsAdMarkers]] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getBaseUrlContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrlContent", baseUrlContent)
    def getBaseUrlContent1: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrlContent1", baseUrlContent1)
    def getBaseUrlManifest: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrlManifest", baseUrlManifest)
    def getBaseUrlManifest1: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrlManifest1", baseUrlManifest1)
    def getCaptionLanguageMappings: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "captionLanguageMappings",
      captionLanguageMappings
    )
    def getCaptionLanguageSetting: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsCaptionLanguageSetting
    ] = AwsError.unwrapOptionField(
      "captionLanguageSetting",
      captionLanguageSetting
    )
    def getClientCache
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsClientCache] =
      AwsError.unwrapOptionField("clientCache", clientCache)
    def getCodecSpecification
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsCodecSpecification] =
      AwsError.unwrapOptionField("codecSpecification", codecSpecification)
    def getConstantIv: ZIO[Any, AwsError, __stringMin32Max32] =
      AwsError.unwrapOptionField("constantIv", constantIv)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getDirectoryStructure
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsDirectoryStructure] =
      AwsError.unwrapOptionField("directoryStructure", directoryStructure)
    def getDiscontinuityTags
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsDiscontinuityTags] =
      AwsError.unwrapOptionField("discontinuityTags", discontinuityTags)
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsEncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getHlsCdnSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsCdnSettings.ReadOnly] =
      AwsError.unwrapOptionField("hlsCdnSettings", hlsCdnSettings)
    def getHlsId3SegmentTagging: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsId3SegmentTaggingState
    ] = AwsError.unwrapOptionField("hlsId3SegmentTagging", hlsId3SegmentTagging)
    def getIFrameOnlyPlaylists
        : ZIO[Any, AwsError, zio.aws.medialive.model.IFrameOnlyPlaylistType] =
      AwsError.unwrapOptionField("iFrameOnlyPlaylists", iFrameOnlyPlaylists)
    def getIncompleteSegmentBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsIncompleteSegmentBehavior
    ] = AwsError.unwrapOptionField(
      "incompleteSegmentBehavior",
      incompleteSegmentBehavior
    )
    def getIndexNSegments: ZIO[Any, AwsError, __integerMin3] =
      AwsError.unwrapOptionField("indexNSegments", indexNSegments)
    def getInputLossAction
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLossActionForHlsOut] =
      AwsError.unwrapOptionField("inputLossAction", inputLossAction)
    def getIvInManifest
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsIvInManifest] =
      AwsError.unwrapOptionField("ivInManifest", ivInManifest)
    def getIvSource: ZIO[Any, AwsError, zio.aws.medialive.model.HlsIvSource] =
      AwsError.unwrapOptionField("ivSource", ivSource)
    def getKeepSegments: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("keepSegments", keepSegments)
    def getKeyFormat: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyFormat", keyFormat)
    def getKeyFormatVersions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyFormatVersions", keyFormatVersions)
    def getKeyProviderSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.KeyProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("keyProviderSettings", keyProviderSettings)
    def getManifestCompression
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsManifestCompression] =
      AwsError.unwrapOptionField("manifestCompression", manifestCompression)
    def getManifestDurationFormat: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsManifestDurationFormat
    ] = AwsError.unwrapOptionField(
      "manifestDurationFormat",
      manifestDurationFormat
    )
    def getMinSegmentLength: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("minSegmentLength", minSegmentLength)
    def getMode: ZIO[Any, AwsError, zio.aws.medialive.model.HlsMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getOutputSelection
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsOutputSelection] =
      AwsError.unwrapOptionField("outputSelection", outputSelection)
    def getProgramDateTime
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsProgramDateTime] =
      AwsError.unwrapOptionField("programDateTime", programDateTime)
    def getProgramDateTimeClock
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsProgramDateTimeClock] =
      AwsError.unwrapOptionField("programDateTimeClock", programDateTimeClock)
    def getProgramDateTimePeriod: ZIO[Any, AwsError, __integerMin0Max3600] =
      AwsError.unwrapOptionField("programDateTimePeriod", programDateTimePeriod)
    def getRedundantManifest
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsRedundantManifest] =
      AwsError.unwrapOptionField("redundantManifest", redundantManifest)
    def getSegmentLength: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("segmentLength", segmentLength)
    def getSegmentationMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsSegmentationMode] =
      AwsError.unwrapOptionField("segmentationMode", segmentationMode)
    def getSegmentsPerSubdirectory: ZIO[Any, AwsError, __integerMin1] = AwsError
      .unwrapOptionField("segmentsPerSubdirectory", segmentsPerSubdirectory)
    def getStreamInfResolution
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsStreamInfResolution] =
      AwsError.unwrapOptionField("streamInfResolution", streamInfResolution)
    def getTimedMetadataId3Frame
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsTimedMetadataId3Frame] =
      AwsError.unwrapOptionField("timedMetadataId3Frame", timedMetadataId3Frame)
    def getTimedMetadataId3Period: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("timedMetadataId3Period", timedMetadataId3Period)
    def getTimestampDeltaMilliseconds: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField(
        "timestampDeltaMilliseconds",
        timestampDeltaMilliseconds
      )
    def getTsFileMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsTsFileMode] =
      AwsError.unwrapOptionField("tsFileMode", tsFileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsGroupSettings
  ) extends zio.aws.medialive.model.HlsGroupSettings.ReadOnly {
    override val adMarkers: Option[List[zio.aws.medialive.model.HlsAdMarkers]] =
      scala
        .Option(impl.adMarkers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.HlsAdMarkers.wrap(item)
          }.toList
        )
    override val baseUrlContent: Option[__string] =
      scala.Option(impl.baseUrlContent()).map(value => value: __string)
    override val baseUrlContent1: Option[__string] =
      scala.Option(impl.baseUrlContent1()).map(value => value: __string)
    override val baseUrlManifest: Option[__string] =
      scala.Option(impl.baseUrlManifest()).map(value => value: __string)
    override val baseUrlManifest1: Option[__string] =
      scala.Option(impl.baseUrlManifest1()).map(value => value: __string)
    override val captionLanguageMappings: Option[
      List[zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly]
    ] = scala
      .Option(impl.captionLanguageMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.CaptionLanguageMapping.wrap(item)
        }.toList
      )
    override val captionLanguageSetting
        : Option[zio.aws.medialive.model.HlsCaptionLanguageSetting] = scala
      .Option(impl.captionLanguageSetting())
      .map(value =>
        zio.aws.medialive.model.HlsCaptionLanguageSetting.wrap(value)
      )
    override val clientCache: Option[zio.aws.medialive.model.HlsClientCache] =
      scala
        .Option(impl.clientCache())
        .map(value => zio.aws.medialive.model.HlsClientCache.wrap(value))
    override val codecSpecification
        : Option[zio.aws.medialive.model.HlsCodecSpecification] = scala
      .Option(impl.codecSpecification())
      .map(value => zio.aws.medialive.model.HlsCodecSpecification.wrap(value))
    override val constantIv: Option[__stringMin32Max32] =
      scala.Option(impl.constantIv()).map(value => value: __stringMin32Max32)
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val directoryStructure
        : Option[zio.aws.medialive.model.HlsDirectoryStructure] = scala
      .Option(impl.directoryStructure())
      .map(value => zio.aws.medialive.model.HlsDirectoryStructure.wrap(value))
    override val discontinuityTags
        : Option[zio.aws.medialive.model.HlsDiscontinuityTags] = scala
      .Option(impl.discontinuityTags())
      .map(value => zio.aws.medialive.model.HlsDiscontinuityTags.wrap(value))
    override val encryptionType
        : Option[zio.aws.medialive.model.HlsEncryptionType] = scala
      .Option(impl.encryptionType())
      .map(value => zio.aws.medialive.model.HlsEncryptionType.wrap(value))
    override val hlsCdnSettings
        : Option[zio.aws.medialive.model.HlsCdnSettings.ReadOnly] = scala
      .Option(impl.hlsCdnSettings())
      .map(value => zio.aws.medialive.model.HlsCdnSettings.wrap(value))
    override val hlsId3SegmentTagging
        : Option[zio.aws.medialive.model.HlsId3SegmentTaggingState] = scala
      .Option(impl.hlsId3SegmentTagging())
      .map(value =>
        zio.aws.medialive.model.HlsId3SegmentTaggingState.wrap(value)
      )
    override val iFrameOnlyPlaylists
        : Option[zio.aws.medialive.model.IFrameOnlyPlaylistType] = scala
      .Option(impl.iFrameOnlyPlaylists())
      .map(value => zio.aws.medialive.model.IFrameOnlyPlaylistType.wrap(value))
    override val incompleteSegmentBehavior
        : Option[zio.aws.medialive.model.HlsIncompleteSegmentBehavior] = scala
      .Option(impl.incompleteSegmentBehavior())
      .map(value =>
        zio.aws.medialive.model.HlsIncompleteSegmentBehavior.wrap(value)
      )
    override val indexNSegments: Option[__integerMin3] =
      scala.Option(impl.indexNSegments()).map(value => value: __integerMin3)
    override val inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForHlsOut] = scala
      .Option(impl.inputLossAction())
      .map(value =>
        zio.aws.medialive.model.InputLossActionForHlsOut.wrap(value)
      )
    override val ivInManifest: Option[zio.aws.medialive.model.HlsIvInManifest] =
      scala
        .Option(impl.ivInManifest())
        .map(value => zio.aws.medialive.model.HlsIvInManifest.wrap(value))
    override val ivSource: Option[zio.aws.medialive.model.HlsIvSource] = scala
      .Option(impl.ivSource())
      .map(value => zio.aws.medialive.model.HlsIvSource.wrap(value))
    override val keepSegments: Option[__integerMin1] =
      scala.Option(impl.keepSegments()).map(value => value: __integerMin1)
    override val keyFormat: Option[__string] =
      scala.Option(impl.keyFormat()).map(value => value: __string)
    override val keyFormatVersions: Option[__string] =
      scala.Option(impl.keyFormatVersions()).map(value => value: __string)
    override val keyProviderSettings
        : Option[zio.aws.medialive.model.KeyProviderSettings.ReadOnly] = scala
      .Option(impl.keyProviderSettings())
      .map(value => zio.aws.medialive.model.KeyProviderSettings.wrap(value))
    override val manifestCompression
        : Option[zio.aws.medialive.model.HlsManifestCompression] = scala
      .Option(impl.manifestCompression())
      .map(value => zio.aws.medialive.model.HlsManifestCompression.wrap(value))
    override val manifestDurationFormat
        : Option[zio.aws.medialive.model.HlsManifestDurationFormat] = scala
      .Option(impl.manifestDurationFormat())
      .map(value =>
        zio.aws.medialive.model.HlsManifestDurationFormat.wrap(value)
      )
    override val minSegmentLength: Option[__integerMin0] =
      scala.Option(impl.minSegmentLength()).map(value => value: __integerMin0)
    override val mode: Option[zio.aws.medialive.model.HlsMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.medialive.model.HlsMode.wrap(value))
    override val outputSelection
        : Option[zio.aws.medialive.model.HlsOutputSelection] = scala
      .Option(impl.outputSelection())
      .map(value => zio.aws.medialive.model.HlsOutputSelection.wrap(value))
    override val programDateTime
        : Option[zio.aws.medialive.model.HlsProgramDateTime] = scala
      .Option(impl.programDateTime())
      .map(value => zio.aws.medialive.model.HlsProgramDateTime.wrap(value))
    override val programDateTimeClock
        : Option[zio.aws.medialive.model.HlsProgramDateTimeClock] = scala
      .Option(impl.programDateTimeClock())
      .map(value => zio.aws.medialive.model.HlsProgramDateTimeClock.wrap(value))
    override val programDateTimePeriod: Option[__integerMin0Max3600] = scala
      .Option(impl.programDateTimePeriod())
      .map(value => value: __integerMin0Max3600)
    override val redundantManifest
        : Option[zio.aws.medialive.model.HlsRedundantManifest] = scala
      .Option(impl.redundantManifest())
      .map(value => zio.aws.medialive.model.HlsRedundantManifest.wrap(value))
    override val segmentLength: Option[__integerMin1] =
      scala.Option(impl.segmentLength()).map(value => value: __integerMin1)
    override val segmentationMode
        : Option[zio.aws.medialive.model.HlsSegmentationMode] = scala
      .Option(impl.segmentationMode())
      .map(value => zio.aws.medialive.model.HlsSegmentationMode.wrap(value))
    override val segmentsPerSubdirectory: Option[__integerMin1] = scala
      .Option(impl.segmentsPerSubdirectory())
      .map(value => value: __integerMin1)
    override val streamInfResolution
        : Option[zio.aws.medialive.model.HlsStreamInfResolution] = scala
      .Option(impl.streamInfResolution())
      .map(value => zio.aws.medialive.model.HlsStreamInfResolution.wrap(value))
    override val timedMetadataId3Frame
        : Option[zio.aws.medialive.model.HlsTimedMetadataId3Frame] = scala
      .Option(impl.timedMetadataId3Frame())
      .map(value =>
        zio.aws.medialive.model.HlsTimedMetadataId3Frame.wrap(value)
      )
    override val timedMetadataId3Period: Option[__integerMin0] = scala
      .Option(impl.timedMetadataId3Period())
      .map(value => value: __integerMin0)
    override val timestampDeltaMilliseconds: Option[__integerMin0] = scala
      .Option(impl.timestampDeltaMilliseconds())
      .map(value => value: __integerMin0)
    override val tsFileMode: Option[zio.aws.medialive.model.HlsTsFileMode] =
      scala
        .Option(impl.tsFileMode())
        .map(value => zio.aws.medialive.model.HlsTsFileMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsGroupSettings
  ): zio.aws.medialive.model.HlsGroupSettings.ReadOnly = new Wrapper(impl)
}
