package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsH265PackagingType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsH265PackagingType
}
object HlsH265PackagingType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsH265PackagingType
  ): zio.aws.medialive.model.HlsH265PackagingType = value match {
    case software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.HEV1 =>
      val r = HEV1
      r
    case software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.HVC1 =>
      val r = HVC1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsH265PackagingType =
      software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.UNKNOWN_TO_SDK_VERSION
  }
  case object HEV1 extends zio.aws.medialive.model.HlsH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsH265PackagingType =
      software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.HEV1
  }
  case object HVC1 extends zio.aws.medialive.model.HlsH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsH265PackagingType =
      software.amazon.awssdk.services.medialive.model.HlsH265PackagingType.HVC1
  }
}
