package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsId3SegmentTaggingState {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState
}
object HlsId3SegmentTaggingState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState
  ): zio.aws.medialive.model.HlsId3SegmentTaggingState = value match {
    case software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsId3SegmentTaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState =
      software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.medialive.model.HlsId3SegmentTaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState =
      software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.DISABLED
  }
  case object ENABLED
      extends zio.aws.medialive.model.HlsId3SegmentTaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState =
      software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState.ENABLED
  }
}
