package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsIncompleteSegmentBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior
}
object HlsIncompleteSegmentBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior
  ): zio.aws.medialive.model.HlsIncompleteSegmentBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.SUPPRESS =>
      val r = SUPPRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsIncompleteSegmentBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior =
      software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO
      extends zio.aws.medialive.model.HlsIncompleteSegmentBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior =
      software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.AUTO
  }
  case object SUPPRESS
      extends zio.aws.medialive.model.HlsIncompleteSegmentBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior =
      software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior.SUPPRESS
  }
}
