package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0
import scala.jdk.CollectionConverters._
final case class HlsInputSettings(
    bandwidth: Option[__integerMin0] = None,
    bufferSegments: Option[__integerMin0] = None,
    retries: Option[__integerMin0] = None,
    retryInterval: Option[__integerMin0] = None,
    scte35Source: Option[zio.aws.medialive.model.HlsScte35SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsInputSettings = {
    import HlsInputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsInputSettings
      .builder()
      .optionallyWith(bandwidth.map(value => value: Integer))(_.bandwidth)
      .optionallyWith(bufferSegments.map(value => value: Integer))(
        _.bufferSegments
      )
      .optionallyWith(retries.map(value => value: Integer))(_.retries)
      .optionallyWith(retryInterval.map(value => value: Integer))(
        _.retryInterval
      )
      .optionallyWith(scte35Source.map(value => value.unwrap))(_.scte35Source)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsInputSettings.ReadOnly =
    zio.aws.medialive.model.HlsInputSettings.wrap(buildAwsValue())
}
object HlsInputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsInputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsInputSettings =
      zio.aws.medialive.model.HlsInputSettings(
        bandwidth.map(value => value),
        bufferSegments.map(value => value),
        retries.map(value => value),
        retryInterval.map(value => value),
        scte35Source.map(value => value)
      )
    def bandwidth: Option[__integerMin0]
    def bufferSegments: Option[__integerMin0]
    def retries: Option[__integerMin0]
    def retryInterval: Option[__integerMin0]
    def scte35Source: Option[zio.aws.medialive.model.HlsScte35SourceType]
    def getBandwidth: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getBufferSegments: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("bufferSegments", bufferSegments)
    def getRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("retries", retries)
    def getRetryInterval: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("retryInterval", retryInterval)
    def getScte35Source
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsScte35SourceType] =
      AwsError.unwrapOptionField("scte35Source", scte35Source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsInputSettings
  ) extends zio.aws.medialive.model.HlsInputSettings.ReadOnly {
    override val bandwidth: Option[__integerMin0] =
      scala.Option(impl.bandwidth()).map(value => value: __integerMin0)
    override val bufferSegments: Option[__integerMin0] =
      scala.Option(impl.bufferSegments()).map(value => value: __integerMin0)
    override val retries: Option[__integerMin0] =
      scala.Option(impl.retries()).map(value => value: __integerMin0)
    override val retryInterval: Option[__integerMin0] =
      scala.Option(impl.retryInterval()).map(value => value: __integerMin0)
    override val scte35Source
        : Option[zio.aws.medialive.model.HlsScte35SourceType] = scala
      .Option(impl.scte35Source())
      .map(value => zio.aws.medialive.model.HlsScte35SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsInputSettings
  ): zio.aws.medialive.model.HlsInputSettings.ReadOnly = new Wrapper(impl)
}
