package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsIvSource {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsIvSource
}
object HlsIvSource {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsIvSource
  ): zio.aws.medialive.model.HlsIvSource = value match {
    case software.amazon.awssdk.services.medialive.model.HlsIvSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsIvSource.EXPLICIT =>
      val r = EXPLICIT
      r
    case software.amazon.awssdk.services.medialive.model.HlsIvSource.FOLLOWS_SEGMENT_NUMBER =>
      val r = FOLLOWS_SEGMENT_NUMBER
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.HlsIvSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIvSource =
      software.amazon.awssdk.services.medialive.model.HlsIvSource.UNKNOWN_TO_SDK_VERSION
  }
  case object EXPLICIT extends zio.aws.medialive.model.HlsIvSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIvSource =
      software.amazon.awssdk.services.medialive.model.HlsIvSource.EXPLICIT
  }
  case object FOLLOWS_SEGMENT_NUMBER
      extends zio.aws.medialive.model.HlsIvSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsIvSource =
      software.amazon.awssdk.services.medialive.model.HlsIvSource.FOLLOWS_SEGMENT_NUMBER
  }
}
