package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsManifestCompression {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsManifestCompression
}
object HlsManifestCompression {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsManifestCompression
  ): zio.aws.medialive.model.HlsManifestCompression = value match {
    case software.amazon.awssdk.services.medialive.model.HlsManifestCompression.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsManifestCompression.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.medialive.model.HlsManifestCompression.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsManifestCompression {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestCompression =
      software.amazon.awssdk.services.medialive.model.HlsManifestCompression.UNKNOWN_TO_SDK_VERSION
  }
  case object GZIP extends zio.aws.medialive.model.HlsManifestCompression {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestCompression =
      software.amazon.awssdk.services.medialive.model.HlsManifestCompression.GZIP
  }
  case object NONE extends zio.aws.medialive.model.HlsManifestCompression {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestCompression =
      software.amazon.awssdk.services.medialive.model.HlsManifestCompression.NONE
  }
}
