package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsManifestDurationFormat {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat
}
object HlsManifestDurationFormat {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat
  ): zio.aws.medialive.model.HlsManifestDurationFormat = value match {
    case software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.FLOATING_POINT =>
      val r = FLOATING_POINT
      r
    case software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.INTEGER =>
      val r = INTEGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsManifestDurationFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat =
      software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object FLOATING_POINT
      extends zio.aws.medialive.model.HlsManifestDurationFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat =
      software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.FLOATING_POINT
  }
  case object INTEGER
      extends zio.aws.medialive.model.HlsManifestDurationFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat =
      software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat.INTEGER
  }
}
