package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsMediaStoreStorageClass {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass
}
object HlsMediaStoreStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass
  ): zio.aws.medialive.model.HlsMediaStoreStorageClass = value match {
    case software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass.TEMPORAL =>
      val r = TEMPORAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsMediaStoreStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass =
      software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object TEMPORAL
      extends zio.aws.medialive.model.HlsMediaStoreStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass =
      software.amazon.awssdk.services.medialive.model.HlsMediaStoreStorageClass.TEMPORAL
  }
}
