package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsMode
}
object HlsMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsMode
  ): zio.aws.medialive.model.HlsMode = value match {
    case software.amazon.awssdk.services.medialive.model.HlsMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsMode.LIVE =>
      val r = LIVE
      r
    case software.amazon.awssdk.services.medialive.model.HlsMode.VOD =>
      val r = VOD
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.HlsMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsMode =
      software.amazon.awssdk.services.medialive.model.HlsMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LIVE extends zio.aws.medialive.model.HlsMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsMode =
      software.amazon.awssdk.services.medialive.model.HlsMode.LIVE
  }
  case object VOD extends zio.aws.medialive.model.HlsMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsMode =
      software.amazon.awssdk.services.medialive.model.HlsMode.VOD
  }
}
