package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsOutputSelection {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsOutputSelection
}
object HlsOutputSelection {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsOutputSelection
  ): zio.aws.medialive.model.HlsOutputSelection = value match {
    case software.amazon.awssdk.services.medialive.model.HlsOutputSelection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsOutputSelection.MANIFESTS_AND_SEGMENTS =>
      val r = MANIFESTS_AND_SEGMENTS
      r
    case software.amazon.awssdk.services.medialive.model.HlsOutputSelection.SEGMENTS_ONLY =>
      val r = SEGMENTS_ONLY
      r
    case software.amazon.awssdk.services.medialive.model.HlsOutputSelection.VARIANT_MANIFESTS_AND_SEGMENTS =>
      val r = VARIANT_MANIFESTS_AND_SEGMENTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsOutputSelection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsOutputSelection =
      software.amazon.awssdk.services.medialive.model.HlsOutputSelection.UNKNOWN_TO_SDK_VERSION
  }
  case object MANIFESTS_AND_SEGMENTS
      extends zio.aws.medialive.model.HlsOutputSelection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsOutputSelection =
      software.amazon.awssdk.services.medialive.model.HlsOutputSelection.MANIFESTS_AND_SEGMENTS
  }
  case object SEGMENTS_ONLY extends zio.aws.medialive.model.HlsOutputSelection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsOutputSelection =
      software.amazon.awssdk.services.medialive.model.HlsOutputSelection.SEGMENTS_ONLY
  }
  case object VARIANT_MANIFESTS_AND_SEGMENTS
      extends zio.aws.medialive.model.HlsOutputSelection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsOutputSelection =
      software.amazon.awssdk.services.medialive.model.HlsOutputSelection.VARIANT_MANIFESTS_AND_SEGMENTS
  }
}
