package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, __stringMin1}
import scala.jdk.CollectionConverters._
final case class HlsOutputSettings(
    h265PackagingType: Option[zio.aws.medialive.model.HlsH265PackagingType] =
      None,
    hlsSettings: zio.aws.medialive.model.HlsSettings,
    nameModifier: Option[__stringMin1] = None,
    segmentModifier: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsOutputSettings = {
    import HlsOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsOutputSettings
      .builder()
      .optionallyWith(h265PackagingType.map(value => value.unwrap))(
        _.h265PackagingType
      )
      .hlsSettings(hlsSettings.buildAwsValue())
      .optionallyWith(nameModifier.map(value => value: java.lang.String))(
        _.nameModifier
      )
      .optionallyWith(segmentModifier.map(value => value: java.lang.String))(
        _.segmentModifier
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsOutputSettings.ReadOnly =
    zio.aws.medialive.model.HlsOutputSettings.wrap(buildAwsValue())
}
object HlsOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsOutputSettings =
      zio.aws.medialive.model.HlsOutputSettings(
        h265PackagingType.map(value => value),
        hlsSettings.asEditable,
        nameModifier.map(value => value),
        segmentModifier.map(value => value)
      )
    def h265PackagingType: Option[zio.aws.medialive.model.HlsH265PackagingType]
    def hlsSettings: zio.aws.medialive.model.HlsSettings.ReadOnly
    def nameModifier: Option[__stringMin1]
    def segmentModifier: Option[__string]
    def getH265PackagingType
        : ZIO[Any, AwsError, zio.aws.medialive.model.HlsH265PackagingType] =
      AwsError.unwrapOptionField("h265PackagingType", h265PackagingType)
    def getHlsSettings
        : ZIO[Any, Nothing, zio.aws.medialive.model.HlsSettings.ReadOnly] =
      ZIO.succeed(hlsSettings)
    def getNameModifier: ZIO[Any, AwsError, __stringMin1] =
      AwsError.unwrapOptionField("nameModifier", nameModifier)
    def getSegmentModifier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentModifier", segmentModifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsOutputSettings
  ) extends zio.aws.medialive.model.HlsOutputSettings.ReadOnly {
    override val h265PackagingType
        : Option[zio.aws.medialive.model.HlsH265PackagingType] = scala
      .Option(impl.h265PackagingType())
      .map(value => zio.aws.medialive.model.HlsH265PackagingType.wrap(value))
    override val hlsSettings: zio.aws.medialive.model.HlsSettings.ReadOnly =
      zio.aws.medialive.model.HlsSettings.wrap(impl.hlsSettings())
    override val nameModifier: Option[__stringMin1] =
      scala.Option(impl.nameModifier()).map(value => value: __stringMin1)
    override val segmentModifier: Option[__string] =
      scala.Option(impl.segmentModifier()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsOutputSettings
  ): zio.aws.medialive.model.HlsOutputSettings.ReadOnly = new Wrapper(impl)
}
