package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsProgramDateTime {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsProgramDateTime
}
object HlsProgramDateTime {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsProgramDateTime
  ): zio.aws.medialive.model.HlsProgramDateTime = value match {
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.EXCLUDE =>
      val r = EXCLUDE
      r
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.INCLUDE =>
      val r = INCLUDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsProgramDateTime {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTime =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.UNKNOWN_TO_SDK_VERSION
  }
  case object EXCLUDE extends zio.aws.medialive.model.HlsProgramDateTime {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTime =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.EXCLUDE
  }
  case object INCLUDE extends zio.aws.medialive.model.HlsProgramDateTime {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTime =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTime.INCLUDE
  }
}
