package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsProgramDateTimeClock {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock
}
object HlsProgramDateTimeClock {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock
  ): zio.aws.medialive.model.HlsProgramDateTimeClock = value match {
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.INITIALIZE_FROM_OUTPUT_TIMECODE =>
      val r = INITIALIZE_FROM_OUTPUT_TIMECODE
      r
    case software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.SYSTEM_CLOCK =>
      val r = SYSTEM_CLOCK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsProgramDateTimeClock {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZE_FROM_OUTPUT_TIMECODE
      extends zio.aws.medialive.model.HlsProgramDateTimeClock {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.INITIALIZE_FROM_OUTPUT_TIMECODE
  }
  case object SYSTEM_CLOCK
      extends zio.aws.medialive.model.HlsProgramDateTimeClock {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock =
      software.amazon.awssdk.services.medialive.model.HlsProgramDateTimeClock.SYSTEM_CLOCK
  }
}
