package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsRedundantManifest {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsRedundantManifest
}
object HlsRedundantManifest {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsRedundantManifest
  ): zio.aws.medialive.model.HlsRedundantManifest = value match {
    case software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsRedundantManifest {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsRedundantManifest =
      software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.HlsRedundantManifest {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsRedundantManifest =
      software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.HlsRedundantManifest {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsRedundantManifest =
      software.amazon.awssdk.services.medialive.model.HlsRedundantManifest.ENABLED
  }
}
