package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HlsS3Settings(
    cannedAcl: Option[zio.aws.medialive.model.S3CannedAcl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsS3Settings = {
    import HlsS3Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsS3Settings
      .builder()
      .optionallyWith(cannedAcl.map(value => value.unwrap))(_.cannedAcl)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsS3Settings.ReadOnly =
    zio.aws.medialive.model.HlsS3Settings.wrap(buildAwsValue())
}
object HlsS3Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsS3Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsS3Settings =
      zio.aws.medialive.model.HlsS3Settings(cannedAcl.map(value => value))
    def cannedAcl: Option[zio.aws.medialive.model.S3CannedAcl]
    def getCannedAcl: ZIO[Any, AwsError, zio.aws.medialive.model.S3CannedAcl] =
      AwsError.unwrapOptionField("cannedAcl", cannedAcl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsS3Settings
  ) extends zio.aws.medialive.model.HlsS3Settings.ReadOnly {
    override val cannedAcl: Option[zio.aws.medialive.model.S3CannedAcl] = scala
      .Option(impl.cannedAcl())
      .map(value => zio.aws.medialive.model.S3CannedAcl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsS3Settings
  ): zio.aws.medialive.model.HlsS3Settings.ReadOnly = new Wrapper(impl)
}
