package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsScte35SourceType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsScte35SourceType
}
object HlsScte35SourceType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsScte35SourceType
  ): zio.aws.medialive.model.HlsScte35SourceType = value match {
    case software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.MANIFEST =>
      val r = MANIFEST
      r
    case software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.SEGMENTS =>
      val r = SEGMENTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsScte35SourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsScte35SourceType =
      software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object MANIFEST extends zio.aws.medialive.model.HlsScte35SourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsScte35SourceType =
      software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.MANIFEST
  }
  case object SEGMENTS extends zio.aws.medialive.model.HlsScte35SourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsScte35SourceType =
      software.amazon.awssdk.services.medialive.model.HlsScte35SourceType.SEGMENTS
  }
}
