package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsSegmentationMode {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsSegmentationMode
}
object HlsSegmentationMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsSegmentationMode
  ): zio.aws.medialive.model.HlsSegmentationMode = value match {
    case software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.USE_INPUT_SEGMENTATION =>
      val r = USE_INPUT_SEGMENTATION
      r
    case software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.USE_SEGMENT_DURATION =>
      val r = USE_SEGMENT_DURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsSegmentationMode =
      software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object USE_INPUT_SEGMENTATION
      extends zio.aws.medialive.model.HlsSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsSegmentationMode =
      software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.USE_INPUT_SEGMENTATION
  }
  case object USE_SEGMENT_DURATION
      extends zio.aws.medialive.model.HlsSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsSegmentationMode =
      software.amazon.awssdk.services.medialive.model.HlsSegmentationMode.USE_SEGMENT_DURATION
  }
}
