package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HlsSettings(
    audioOnlyHlsSettings: Option[zio.aws.medialive.model.AudioOnlyHlsSettings] =
      None,
    fmp4HlsSettings: Option[zio.aws.medialive.model.Fmp4HlsSettings] = None,
    frameCaptureHlsSettings: Option[
      zio.aws.medialive.model.FrameCaptureHlsSettings
    ] = None,
    standardHlsSettings: Option[zio.aws.medialive.model.StandardHlsSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsSettings = {
    import HlsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsSettings
      .builder()
      .optionallyWith(audioOnlyHlsSettings.map(value => value.buildAwsValue()))(
        _.audioOnlyHlsSettings
      )
      .optionallyWith(fmp4HlsSettings.map(value => value.buildAwsValue()))(
        _.fmp4HlsSettings
      )
      .optionallyWith(
        frameCaptureHlsSettings.map(value => value.buildAwsValue())
      )(_.frameCaptureHlsSettings)
      .optionallyWith(standardHlsSettings.map(value => value.buildAwsValue()))(
        _.standardHlsSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsSettings.ReadOnly =
    zio.aws.medialive.model.HlsSettings.wrap(buildAwsValue())
}
object HlsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsSettings =
      zio.aws.medialive.model.HlsSettings(
        audioOnlyHlsSettings.map(value => value.asEditable),
        fmp4HlsSettings.map(value => value.asEditable),
        frameCaptureHlsSettings.map(value => value.asEditable),
        standardHlsSettings.map(value => value.asEditable)
      )
    def audioOnlyHlsSettings
        : Option[zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly]
    def fmp4HlsSettings
        : Option[zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly]
    def frameCaptureHlsSettings
        : Option[zio.aws.medialive.model.FrameCaptureHlsSettings.ReadOnly]
    def standardHlsSettings
        : Option[zio.aws.medialive.model.StandardHlsSettings.ReadOnly]
    def getAudioOnlyHlsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("audioOnlyHlsSettings", audioOnlyHlsSettings)
    def getFmp4HlsSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly] =
      AwsError.unwrapOptionField("fmp4HlsSettings", fmp4HlsSettings)
    def getFrameCaptureHlsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureHlsSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameCaptureHlsSettings",
      frameCaptureHlsSettings
    )
    def getStandardHlsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.StandardHlsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("standardHlsSettings", standardHlsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsSettings
  ) extends zio.aws.medialive.model.HlsSettings.ReadOnly {
    override val audioOnlyHlsSettings
        : Option[zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly] = scala
      .Option(impl.audioOnlyHlsSettings())
      .map(value => zio.aws.medialive.model.AudioOnlyHlsSettings.wrap(value))
    override val fmp4HlsSettings
        : Option[zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly] = scala
      .Option(impl.fmp4HlsSettings())
      .map(value => zio.aws.medialive.model.Fmp4HlsSettings.wrap(value))
    override val frameCaptureHlsSettings
        : Option[zio.aws.medialive.model.FrameCaptureHlsSettings.ReadOnly] =
      scala
        .Option(impl.frameCaptureHlsSettings())
        .map(value =>
          zio.aws.medialive.model.FrameCaptureHlsSettings.wrap(value)
        )
    override val standardHlsSettings
        : Option[zio.aws.medialive.model.StandardHlsSettings.ReadOnly] = scala
      .Option(impl.standardHlsSettings())
      .map(value => zio.aws.medialive.model.StandardHlsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsSettings
  ): zio.aws.medialive.model.HlsSettings.ReadOnly = new Wrapper(impl)
}
