package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsStreamInfResolution {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution
}
object HlsStreamInfResolution {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution
  ): zio.aws.medialive.model.HlsStreamInfResolution = value match {
    case software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.EXCLUDE =>
      val r = EXCLUDE
      r
    case software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.INCLUDE =>
      val r = INCLUDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsStreamInfResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution =
      software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.UNKNOWN_TO_SDK_VERSION
  }
  case object EXCLUDE extends zio.aws.medialive.model.HlsStreamInfResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution =
      software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.EXCLUDE
  }
  case object INCLUDE extends zio.aws.medialive.model.HlsStreamInfResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution =
      software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution.INCLUDE
  }
}
