package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsTsFileMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsTsFileMode
}
object HlsTsFileMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsTsFileMode
  ): zio.aws.medialive.model.HlsTsFileMode = value match {
    case software.amazon.awssdk.services.medialive.model.HlsTsFileMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsTsFileMode.SEGMENTED_FILES =>
      val r = SEGMENTED_FILES
      r
    case software.amazon.awssdk.services.medialive.model.HlsTsFileMode.SINGLE_FILE =>
      val r = SINGLE_FILE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsTsFileMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsTsFileMode =
      software.amazon.awssdk.services.medialive.model.HlsTsFileMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SEGMENTED_FILES extends zio.aws.medialive.model.HlsTsFileMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsTsFileMode =
      software.amazon.awssdk.services.medialive.model.HlsTsFileMode.SEGMENTED_FILES
  }
  case object SINGLE_FILE extends zio.aws.medialive.model.HlsTsFileMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsTsFileMode =
      software.amazon.awssdk.services.medialive.model.HlsTsFileMode.SINGLE_FILE
  }
}
