package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait HlsWebdavHttpTransferMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode
}
object HlsWebdavHttpTransferMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode
  ): zio.aws.medialive.model.HlsWebdavHttpTransferMode = value match {
    case software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.CHUNKED =>
      val r = CHUNKED
      r
    case software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.NON_CHUNKED =>
      val r = NON_CHUNKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.HlsWebdavHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CHUNKED
      extends zio.aws.medialive.model.HlsWebdavHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.CHUNKED
  }
  case object NON_CHUNKED
      extends zio.aws.medialive.model.HlsWebdavHttpTransferMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode =
      software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode.NON_CHUNKED
  }
}
