package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max15,
  __integerMin0Max600,
  __integerMin0
}
import scala.jdk.CollectionConverters._
final case class HlsWebdavSettings(
    connectionRetryInterval: Option[__integerMin0] = None,
    filecacheDuration: Option[__integerMin0Max600] = None,
    httpTransferMode: Option[
      zio.aws.medialive.model.HlsWebdavHttpTransferMode
    ] = None,
    numRetries: Option[__integerMin0] = None,
    restartDelay: Option[__integerMin0Max15] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.HlsWebdavSettings = {
    import HlsWebdavSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.HlsWebdavSettings
      .builder()
      .optionallyWith(connectionRetryInterval.map(value => value: Integer))(
        _.connectionRetryInterval
      )
      .optionallyWith(filecacheDuration.map(value => value: Integer))(
        _.filecacheDuration
      )
      .optionallyWith(httpTransferMode.map(value => value.unwrap))(
        _.httpTransferMode
      )
      .optionallyWith(numRetries.map(value => value: Integer))(_.numRetries)
      .optionallyWith(restartDelay.map(value => value: Integer))(_.restartDelay)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.HlsWebdavSettings.ReadOnly =
    zio.aws.medialive.model.HlsWebdavSettings.wrap(buildAwsValue())
}
object HlsWebdavSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.HlsWebdavSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.HlsWebdavSettings =
      zio.aws.medialive.model.HlsWebdavSettings(
        connectionRetryInterval.map(value => value),
        filecacheDuration.map(value => value),
        httpTransferMode.map(value => value),
        numRetries.map(value => value),
        restartDelay.map(value => value)
      )
    def connectionRetryInterval: Option[__integerMin0]
    def filecacheDuration: Option[__integerMin0Max600]
    def httpTransferMode
        : Option[zio.aws.medialive.model.HlsWebdavHttpTransferMode]
    def numRetries: Option[__integerMin0]
    def restartDelay: Option[__integerMin0Max15]
    def getConnectionRetryInterval: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("connectionRetryInterval", connectionRetryInterval)
    def getFilecacheDuration: ZIO[Any, AwsError, __integerMin0Max600] =
      AwsError.unwrapOptionField("filecacheDuration", filecacheDuration)
    def getHttpTransferMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsWebdavHttpTransferMode
    ] = AwsError.unwrapOptionField("httpTransferMode", httpTransferMode)
    def getNumRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("numRetries", numRetries)
    def getRestartDelay: ZIO[Any, AwsError, __integerMin0Max15] =
      AwsError.unwrapOptionField("restartDelay", restartDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.HlsWebdavSettings
  ) extends zio.aws.medialive.model.HlsWebdavSettings.ReadOnly {
    override val connectionRetryInterval: Option[__integerMin0] = scala
      .Option(impl.connectionRetryInterval())
      .map(value => value: __integerMin0)
    override val filecacheDuration: Option[__integerMin0Max600] = scala
      .Option(impl.filecacheDuration())
      .map(value => value: __integerMin0Max600)
    override val httpTransferMode
        : Option[zio.aws.medialive.model.HlsWebdavHttpTransferMode] = scala
      .Option(impl.httpTransferMode())
      .map(value =>
        zio.aws.medialive.model.HlsWebdavHttpTransferMode.wrap(value)
      )
    override val numRetries: Option[__integerMin0] =
      scala.Option(impl.numRetries()).map(value => value: __integerMin0)
    override val restartDelay: Option[__integerMin0Max15] =
      scala.Option(impl.restartDelay()).map(value => value: __integerMin0Max15)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.HlsWebdavSettings
  ): zio.aws.medialive.model.HlsWebdavSettings.ReadOnly = new Wrapper(impl)
}
