package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait IFrameOnlyPlaylistType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType
}
object IFrameOnlyPlaylistType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType
  ): zio.aws.medialive.model.IFrameOnlyPlaylistType = value match {
    case software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.IFrameOnlyPlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType =
      software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.IFrameOnlyPlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType =
      software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.DISABLED
  }
  case object STANDARD extends zio.aws.medialive.model.IFrameOnlyPlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType =
      software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType.STANDARD
  }
}
