package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class Input(
    arn: Option[__string] = None,
    attachedChannels: Option[Iterable[__string]] = None,
    destinations: Option[Iterable[zio.aws.medialive.model.InputDestination]] =
      None,
    id: Option[__string] = None,
    inputClass: Option[zio.aws.medialive.model.InputClass] = None,
    inputDevices: Option[
      Iterable[zio.aws.medialive.model.InputDeviceSettings]
    ] = None,
    inputPartnerIds: Option[Iterable[__string]] = None,
    inputSourceType: Option[zio.aws.medialive.model.InputSourceType] = None,
    mediaConnectFlows: Option[
      Iterable[zio.aws.medialive.model.MediaConnectFlow]
    ] = None,
    name: Option[__string] = None,
    roleArn: Option[__string] = None,
    securityGroups: Option[Iterable[__string]] = None,
    sources: Option[Iterable[zio.aws.medialive.model.InputSource]] = None,
    state: Option[zio.aws.medialive.model.InputState] = None,
    tags: Option[Map[__string, __string]] = None,
    `type`: Option[zio.aws.medialive.model.InputType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.medialive.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Input
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        attachedChannels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attachedChannels)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(inputClass.map(value => value.unwrap))(_.inputClass)
      .optionallyWith(
        inputDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDevices)
      .optionallyWith(
        inputPartnerIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputPartnerIds)
      .optionallyWith(inputSourceType.map(value => value.unwrap))(
        _.inputSourceType
      )
      .optionallyWith(
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaConnectFlows)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Input.ReadOnly =
    zio.aws.medialive.model.Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.medialive.model.Input] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Input =
      zio.aws.medialive.model.Input(
        arn.map(value => value),
        attachedChannels.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        inputClass.map(value => value),
        inputDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputPartnerIds.map(value => value),
        inputSourceType.map(value => value),
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        roleArn.map(value => value),
        securityGroups.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def arn: Option[__string]
    def attachedChannels: Option[List[__string]]
    def destinations
        : Option[List[zio.aws.medialive.model.InputDestination.ReadOnly]]
    def id: Option[__string]
    def inputClass: Option[zio.aws.medialive.model.InputClass]
    def inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSettings.ReadOnly]]
    def inputPartnerIds: Option[List[__string]]
    def inputSourceType: Option[zio.aws.medialive.model.InputSourceType]
    def mediaConnectFlows
        : Option[List[zio.aws.medialive.model.MediaConnectFlow.ReadOnly]]
    def name: Option[__string]
    def roleArn: Option[__string]
    def securityGroups: Option[List[__string]]
    def sources: Option[List[zio.aws.medialive.model.InputSource.ReadOnly]]
    def state: Option[zio.aws.medialive.model.InputState]
    def tags: Option[Map[__string, __string]]
    def `type`: Option[zio.aws.medialive.model.InputType]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAttachedChannels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("attachedChannels", attachedChannels)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getInputClass: ZIO[Any, AwsError, zio.aws.medialive.model.InputClass] =
      AwsError.unwrapOptionField("inputClass", inputClass)
    def getInputDevices: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDeviceSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDevices", inputDevices)
    def getInputPartnerIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputPartnerIds", inputPartnerIds)
    def getInputSourceType
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputSourceType] =
      AwsError.unwrapOptionField("inputSourceType", inputSourceType)
    def getMediaConnectFlows: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MediaConnectFlow.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaConnectFlows", mediaConnectFlows)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getState: ZIO[Any, AwsError, zio.aws.medialive.model.InputState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.medialive.model.InputType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Input
  ) extends zio.aws.medialive.model.Input.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val attachedChannels: Option[List[__string]] = scala
      .Option(impl.attachedChannels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val destinations
        : Option[List[zio.aws.medialive.model.InputDestination.ReadOnly]] =
      scala
        .Option(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputDestination.wrap(item)
          }.toList
        )
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val inputClass: Option[zio.aws.medialive.model.InputClass] = scala
      .Option(impl.inputClass())
      .map(value => zio.aws.medialive.model.InputClass.wrap(value))
    override val inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSettings.ReadOnly]] =
      scala
        .Option(impl.inputDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputDeviceSettings.wrap(item)
          }.toList
        )
    override val inputPartnerIds: Option[List[__string]] = scala
      .Option(impl.inputPartnerIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val inputSourceType
        : Option[zio.aws.medialive.model.InputSourceType] = scala
      .Option(impl.inputSourceType())
      .map(value => zio.aws.medialive.model.InputSourceType.wrap(value))
    override val mediaConnectFlows
        : Option[List[zio.aws.medialive.model.MediaConnectFlow.ReadOnly]] =
      scala
        .Option(impl.mediaConnectFlows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.MediaConnectFlow.wrap(item)
          }.toList
        )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
    override val securityGroups: Option[List[__string]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val sources
        : Option[List[zio.aws.medialive.model.InputSource.ReadOnly]] = scala
      .Option(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputSource.wrap(item)
        }.toList
      )
    override val state: Option[zio.aws.medialive.model.InputState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.InputState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.medialive.model.InputType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.medialive.model.InputType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Input
  ): zio.aws.medialive.model.Input.ReadOnly = new Wrapper(impl)
}
