package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputAttachment(
    automaticInputFailoverSettings: Option[
      zio.aws.medialive.model.AutomaticInputFailoverSettings
    ] = None,
    inputAttachmentName: Option[__string] = None,
    inputId: Option[__string] = None,
    inputSettings: Option[zio.aws.medialive.model.InputSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputAttachment = {
    import InputAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputAttachment
      .builder()
      .optionallyWith(
        automaticInputFailoverSettings.map(value => value.buildAwsValue())
      )(_.automaticInputFailoverSettings)
      .optionallyWith(
        inputAttachmentName.map(value => value: java.lang.String)
      )(_.inputAttachmentName)
      .optionallyWith(inputId.map(value => value: java.lang.String))(_.inputId)
      .optionallyWith(inputSettings.map(value => value.buildAwsValue()))(
        _.inputSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputAttachment.ReadOnly =
    zio.aws.medialive.model.InputAttachment.wrap(buildAwsValue())
}
object InputAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputAttachment =
      zio.aws.medialive.model.InputAttachment(
        automaticInputFailoverSettings.map(value => value.asEditable),
        inputAttachmentName.map(value => value),
        inputId.map(value => value),
        inputSettings.map(value => value.asEditable)
      )
    def automaticInputFailoverSettings: Option[
      zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly
    ]
    def inputAttachmentName: Option[__string]
    def inputId: Option[__string]
    def inputSettings: Option[zio.aws.medialive.model.InputSettings.ReadOnly]
    def getAutomaticInputFailoverSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "automaticInputFailoverSettings",
      automaticInputFailoverSettings
    )
    def getInputAttachmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("inputAttachmentName", inputAttachmentName)
    def getInputId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getInputSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputSettings.ReadOnly] =
      AwsError.unwrapOptionField("inputSettings", inputSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputAttachment
  ) extends zio.aws.medialive.model.InputAttachment.ReadOnly {
    override val automaticInputFailoverSettings: Option[
      zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly
    ] = scala
      .Option(impl.automaticInputFailoverSettings())
      .map(value =>
        zio.aws.medialive.model.AutomaticInputFailoverSettings.wrap(value)
      )
    override val inputAttachmentName: Option[__string] =
      scala.Option(impl.inputAttachmentName()).map(value => value: __string)
    override val inputId: Option[__string] =
      scala.Option(impl.inputId()).map(value => value: __string)
    override val inputSettings
        : Option[zio.aws.medialive.model.InputSettings.ReadOnly] = scala
      .Option(impl.inputSettings())
      .map(value => zio.aws.medialive.model.InputSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputAttachment
  ): zio.aws.medialive.model.InputAttachment.ReadOnly = new Wrapper(impl)
}
