package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.{
  __integerMin0Max15,
  __integerMinNegative60Max6
}
import scala.jdk.CollectionConverters._
final case class InputChannelLevel(
    gain: __integerMinNegative60Max6,
    inputChannel: __integerMin0Max15
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputChannelLevel = {
    import InputChannelLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputChannelLevel
      .builder()
      .gain(gain: Integer)
      .inputChannel(inputChannel: Integer)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputChannelLevel.ReadOnly =
    zio.aws.medialive.model.InputChannelLevel.wrap(buildAwsValue())
}
object InputChannelLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputChannelLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputChannelLevel =
      zio.aws.medialive.model.InputChannelLevel(gain, inputChannel)
    def gain: __integerMinNegative60Max6
    def inputChannel: __integerMin0Max15
    def getGain: ZIO[Any, Nothing, __integerMinNegative60Max6] =
      ZIO.succeed(gain)
    def getInputChannel: ZIO[Any, Nothing, __integerMin0Max15] =
      ZIO.succeed(inputChannel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputChannelLevel
  ) extends zio.aws.medialive.model.InputChannelLevel.ReadOnly {
    override val gain: __integerMinNegative60Max6 =
      impl.gain(): __integerMinNegative60Max6
    override val inputChannel: __integerMin0Max15 =
      impl.inputChannel(): __integerMin0Max15
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputChannelLevel
  ): zio.aws.medialive.model.InputChannelLevel.ReadOnly = new Wrapper(impl)
}
