package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputClass {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputClass
}
object InputClass {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputClass
  ): zio.aws.medialive.model.InputClass = value match {
    case software.amazon.awssdk.services.medialive.model.InputClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.medialive.model.InputClass.SINGLE_PIPELINE =>
      val r = SINGLE_PIPELINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.InputClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputClass =
      software.amazon.awssdk.services.medialive.model.InputClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.medialive.model.InputClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputClass =
      software.amazon.awssdk.services.medialive.model.InputClass.STANDARD
  }
  case object SINGLE_PIPELINE extends zio.aws.medialive.model.InputClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputClass =
      software.amazon.awssdk.services.medialive.model.InputClass.SINGLE_PIPELINE
  }
}
