package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputClippingSettings(
    inputTimecodeSource: zio.aws.medialive.model.InputTimecodeSource,
    startTimecode: Option[zio.aws.medialive.model.StartTimecode] = None,
    stopTimecode: Option[zio.aws.medialive.model.StopTimecode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputClippingSettings = {
    import InputClippingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputClippingSettings
      .builder()
      .inputTimecodeSource(inputTimecodeSource.unwrap)
      .optionallyWith(startTimecode.map(value => value.buildAwsValue()))(
        _.startTimecode
      )
      .optionallyWith(stopTimecode.map(value => value.buildAwsValue()))(
        _.stopTimecode
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputClippingSettings.ReadOnly =
    zio.aws.medialive.model.InputClippingSettings.wrap(buildAwsValue())
}
object InputClippingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputClippingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputClippingSettings =
      zio.aws.medialive.model.InputClippingSettings(
        inputTimecodeSource,
        startTimecode.map(value => value.asEditable),
        stopTimecode.map(value => value.asEditable)
      )
    def inputTimecodeSource: zio.aws.medialive.model.InputTimecodeSource
    def startTimecode: Option[zio.aws.medialive.model.StartTimecode.ReadOnly]
    def stopTimecode: Option[zio.aws.medialive.model.StopTimecode.ReadOnly]
    def getInputTimecodeSource
        : ZIO[Any, Nothing, zio.aws.medialive.model.InputTimecodeSource] =
      ZIO.succeed(inputTimecodeSource)
    def getStartTimecode
        : ZIO[Any, AwsError, zio.aws.medialive.model.StartTimecode.ReadOnly] =
      AwsError.unwrapOptionField("startTimecode", startTimecode)
    def getStopTimecode
        : ZIO[Any, AwsError, zio.aws.medialive.model.StopTimecode.ReadOnly] =
      AwsError.unwrapOptionField("stopTimecode", stopTimecode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputClippingSettings
  ) extends zio.aws.medialive.model.InputClippingSettings.ReadOnly {
    override val inputTimecodeSource
        : zio.aws.medialive.model.InputTimecodeSource =
      zio.aws.medialive.model.InputTimecodeSource
        .wrap(impl.inputTimecodeSource())
    override val startTimecode
        : Option[zio.aws.medialive.model.StartTimecode.ReadOnly] = scala
      .Option(impl.startTimecode())
      .map(value => zio.aws.medialive.model.StartTimecode.wrap(value))
    override val stopTimecode
        : Option[zio.aws.medialive.model.StopTimecode.ReadOnly] = scala
      .Option(impl.stopTimecode())
      .map(value => zio.aws.medialive.model.StopTimecode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputClippingSettings
  ): zio.aws.medialive.model.InputClippingSettings.ReadOnly = new Wrapper(impl)
}
