package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputCodec {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputCodec
}
object InputCodec {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputCodec
  ): zio.aws.medialive.model.InputCodec = value match {
    case software.amazon.awssdk.services.medialive.model.InputCodec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputCodec.MPEG2 =>
      val r = MPEG2
      r
    case software.amazon.awssdk.services.medialive.model.InputCodec.AVC =>
      val r = AVC
      r
    case software.amazon.awssdk.services.medialive.model.InputCodec.HEVC =>
      val r = HEVC
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.InputCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputCodec =
      software.amazon.awssdk.services.medialive.model.InputCodec.UNKNOWN_TO_SDK_VERSION
  }
  case object MPEG2 extends zio.aws.medialive.model.InputCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputCodec =
      software.amazon.awssdk.services.medialive.model.InputCodec.MPEG2
  }
  case object AVC extends zio.aws.medialive.model.InputCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputCodec =
      software.amazon.awssdk.services.medialive.model.InputCodec.AVC
  }
  case object HEVC extends zio.aws.medialive.model.InputCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputCodec =
      software.amazon.awssdk.services.medialive.model.InputCodec.HEVC
  }
}
