package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeblockFilter {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDeblockFilter
}
object InputDeblockFilter {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeblockFilter
  ): zio.aws.medialive.model.InputDeblockFilter = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeblockFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeblockFilter.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.InputDeblockFilter.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeblockFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeblockFilter =
      software.amazon.awssdk.services.medialive.model.InputDeblockFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.InputDeblockFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeblockFilter =
      software.amazon.awssdk.services.medialive.model.InputDeblockFilter.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.InputDeblockFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeblockFilter =
      software.amazon.awssdk.services.medialive.model.InputDeblockFilter.ENABLED
  }
}
