package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDenoiseFilter {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDenoiseFilter
}
object InputDenoiseFilter {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDenoiseFilter
  ): zio.aws.medialive.model.InputDenoiseFilter = value match {
    case software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDenoiseFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDenoiseFilter =
      software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.InputDenoiseFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDenoiseFilter =
      software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.InputDenoiseFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDenoiseFilter =
      software.amazon.awssdk.services.medialive.model.InputDenoiseFilter.ENABLED
  }
}
