package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputDestination(
    ip: Option[__string] = None,
    port: Option[__string] = None,
    url: Option[__string] = None,
    vpc: Option[zio.aws.medialive.model.InputDestinationVpc] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDestination = {
    import InputDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDestination
      .builder()
      .optionallyWith(ip.map(value => value: java.lang.String))(_.ip)
      .optionallyWith(port.map(value => value: java.lang.String))(_.port)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDestination.ReadOnly =
    zio.aws.medialive.model.InputDestination.wrap(buildAwsValue())
}
object InputDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDestination =
      zio.aws.medialive.model.InputDestination(
        ip.map(value => value),
        port.map(value => value),
        url.map(value => value),
        vpc.map(value => value.asEditable)
      )
    def ip: Option[__string]
    def port: Option[__string]
    def url: Option[__string]
    def vpc: Option[zio.aws.medialive.model.InputDestinationVpc.ReadOnly]
    def getIp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ip", ip)
    def getPort: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("port", port)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getVpc: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDestinationVpc.ReadOnly
    ] = AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDestination
  ) extends zio.aws.medialive.model.InputDestination.ReadOnly {
    override val ip: Option[__string] =
      scala.Option(impl.ip()).map(value => value: __string)
    override val port: Option[__string] =
      scala.Option(impl.port()).map(value => value: __string)
    override val url: Option[__string] =
      scala.Option(impl.url()).map(value => value: __string)
    override val vpc
        : Option[zio.aws.medialive.model.InputDestinationVpc.ReadOnly] = scala
      .Option(impl.vpc())
      .map(value => zio.aws.medialive.model.InputDestinationVpc.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDestination
  ): zio.aws.medialive.model.InputDestination.ReadOnly = new Wrapper(impl)
}
