package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputDestinationRequest(streamName: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDestinationRequest = {
    import InputDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDestinationRequest
      .builder()
      .optionallyWith(streamName.map(value => value: java.lang.String))(
        _.streamName
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDestinationRequest.ReadOnly =
    zio.aws.medialive.model.InputDestinationRequest.wrap(buildAwsValue())
}
object InputDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDestinationRequest =
      zio.aws.medialive.model
        .InputDestinationRequest(streamName.map(value => value))
    def streamName: Option[__string]
    def getStreamName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamName", streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDestinationRequest
  ) extends zio.aws.medialive.model.InputDestinationRequest.ReadOnly {
    override val streamName: Option[__string] =
      scala.Option(impl.streamName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDestinationRequest
  ): zio.aws.medialive.model.InputDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
